package com.duiba.tuia.youtui.web.message.handlers;

import cn.com.duiba.tuia.activity.center.api.constant.EventKeys;
import com.duiba.tuia.youtui.web.message.AbstractMessageResultHandler;
import com.duiba.tuia.youtui.web.message.ActivityWebCacheBashHandler;
import com.duiba.tuia.youtui.web.message.RocketMqMessageListener;
import com.duiba.tuia.youtui.web.service.ActivityService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 清楚奖项缓存的handler，不区分插件奖项缓存还是活动奖项缓存
 * @author lichao 2018/4/20
 */
@Component
public class OptionsHandler extends ActivityWebCacheBashHandler {

    @Autowired
    private ActivityService activityService;
    /**
     * 获取消费tag
     *
     */
    @Override
    public String getListenTag() {

        return EventKeys.OPTIONS.getKey();
    }

    @Override
    public void consumerNative(String message) {
        activityService.refreshCache("optionsCache",message);
    }

}
