package com.duiba.tuia.youtui.web.message.handlers;

import cn.com.duiba.tuia.ssp.center.api.constant.EventKeys;
import com.duiba.tuia.youtui.web.message.AbstractMessageResultHandler;
import com.duiba.tuia.youtui.web.message.ActivityWebCacheBashHandler;
import com.duiba.tuia.youtui.web.message.RocketMqMessageListener;
import com.duiba.tuia.youtui.web.service.AppService;
import com.google.common.primitives.Longs;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 刷新appService中的缓存的事件监听类
 *
 * @author lichao 2018/4/17
 */
@Component
public class AppServiceHandler extends ActivityWebCacheBashHandler {

    @Autowired
    private AppService appService;

    /**
     * 获取消费tag
     * getListenTag:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public String getListenTag() {
        return EventKeys.CACHE_MEDIAAPP.getKey();
    }

    @Override
    public void consumerNative(String message) {
        if(StringUtils.isNotBlank(message)) {
            String[] messages = message.split(";");
            Long appid = null;
            if(messages.length!=2||(appid=Longs.tryParse(messages[0]))==null){
                logger.warn("接收到错误消息："+getListenTag()+":"+message);
                return;
            }
            appService.refreshCache(appid,messages[1]);
        }
    }


}
