package com.duiba.tuia.youtui.web.handle.prize;

import cn.com.duiba.tuia.activity.center.api.constant.ActivityOptionType;
import com.duiba.tuia.youtui.web.handle.FilterChain;
import com.google.common.collect.Sets;
import java.util.Set;

/**
 * 实发奖品中奖逻辑
 *
 * 扩展PrizeFilter 姿势：
 * 1.新增XXFilter extends PrizeFilter
 * 2.PrizeFilterHandle.afterPropertiesSet() 里注册新的过滤组件
 * 3.实现configPrizes(),配置执行此过滤组件的奖品类型
 * 4.实现doFilter,过滤主逻辑
 * 5.getOffset() 定义执行顺序
 * 6.写注释详细描述过滤逻辑
 *
 * Created by 清郎 on 2018/01/31.
 */
public abstract class PrizeFilter implements FilterChain{

    private Set<String> prizes = Sets.newHashSet();

    protected void configPrizes(ActivityOptionType... activityOptionTypes) {
        for (ActivityOptionType activityOptionType : activityOptionTypes) {
            prizes.add(activityOptionType.getCode());
        }
    }
    protected abstract void configPrizes();

    public boolean checkPrize(String prizeType) {
        return prizes.contains(prizeType);
    }
}
