package com.duiba.tuia.youtui.web.embed;

/**
 * zhouwb
 */
public class ThanksRecomendEmbed extends Embed{
    private String orderId;
    private Long advertId;
    private Long materialId;
    private Long activityId;
    private String couponSource;
    /** 直投页来源 */
    private Long directpage;

    private ThanksRecomendEmbed(String dcm, String dsm, String dpm, Long consumerId, Long appId, String host) {
        super(dcm, dsm, dpm, consumerId, appId, host);
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getCouponSource() {
        return couponSource;
    }

    public void setCouponSource(String couponSource) {
        this.couponSource = couponSource;
    }

    public Long getDirectpage() {
        return directpage;
    }

    public void setDirectpage(Long directpage) {
        this.directpage = directpage;
    }

    public String btnClickInfo(){
        return super.buildClickEmbed();
    }

    public  String btnExposureInfo(){
        this.buildExposureEmbed();
        return super.embed().get("st_info_dpm_exposure");
    }

    public  String advertExposureInfo(){
        this.buildAdvertEmbed4Web();
        return super.embed().get("st_info_dpm_advert_exposure");
    }

    public static final class ThanksRecomendEmbedBuilder {
        private String orderId;
        private Long advertId;
        private Long materialId;
        private Long activityId;
        private String couponSource;
        private String dcm;
        private String dsm;
        private String dpm;
        private Long consumerId;
        private Long appId;
        private String host;
        private Long directpage;

        private ThanksRecomendEmbedBuilder() {
        }

        public static ThanksRecomendEmbedBuilder newThanksRecomendEmbed() {
            return new ThanksRecomendEmbedBuilder();
        }

        public ThanksRecomendEmbedBuilder withOrderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public ThanksRecomendEmbedBuilder withAdvertId(Long advertId) {
            this.advertId = advertId;
            return this;
        }

        public ThanksRecomendEmbedBuilder withMaterialId(Long materialId) {
            this.materialId = materialId;
            return this;
        }

        public ThanksRecomendEmbedBuilder withActivityId(Long activityId) {
            this.activityId = activityId;
            return this;
        }

        public ThanksRecomendEmbedBuilder withCouponSource(String couponSource) {
            this.couponSource = couponSource;
            return this;
        }

        public ThanksRecomendEmbedBuilder withDcm(String dcm) {
            this.dcm = dcm;
            return this;
        }

        public ThanksRecomendEmbedBuilder withDsm(String dsm) {
            this.dsm = dsm;
            return this;
        }

        public ThanksRecomendEmbedBuilder withDpm(String dpm) {
            this.dpm = dpm;
            return this;
        }

        public ThanksRecomendEmbedBuilder withConsumerId(Long consumerId) {
            this.consumerId = consumerId;
            return this;
        }

        public ThanksRecomendEmbedBuilder withAppId(Long appId) {
            this.appId = appId;
            return this;
        }

        public ThanksRecomendEmbedBuilder withHost(String host) {
            this.host = host;
            return this;
        }
        public ThanksRecomendEmbedBuilder withDirectpage(Long directpage) {
            this.directpage = directpage;
            return this;
        }

        public ThanksRecomendEmbed build() {
            ThanksRecomendEmbed thanksRecomendEmbed = new ThanksRecomendEmbed(dcm, dsm, dpm, consumerId, appId, host);
            thanksRecomendEmbed.setOrderId(orderId);
            thanksRecomendEmbed.setAdvertId(advertId);
            thanksRecomendEmbed.setMaterialId(materialId);
            thanksRecomendEmbed.setActivityId(activityId);
            thanksRecomendEmbed.setCouponSource(couponSource);
            thanksRecomendEmbed.setDirectpage(directpage);
            return thanksRecomendEmbed;
        }
    }
}
