package com.duiba.tuia.youtui.web.embed;

import com.duiba.tuia.youtui.web.constant.Constants;

/**
 * 瓜分红包相关埋点
 *
 * 需求文档：http://cf.dui88.com/pages/viewpage.action?pageId=7682381
 */
public class RedPacketEmbed extends Embed {

    public RedPacketEmbed(String dcm, String dsm, String dpm, Long consumerId, Long appId, String host) {
        super(dcm, dsm, dpm, consumerId, appId, host);
    }

    public RedPacketEmbed buildEmbed() {
        // 瓜分红包页                                                                                                                    瓜分红包页
        super.setDpm(DpmBuilder.directBlockBuild(getAppId(), Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_login_wallet");//登陆绑定按钮曝光
        super.setDpm(DpmBuilder.directBlockBuild(getAppId(), Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_login_wallet");//登陆绑定按钮点击
        super.setDpm(DpmBuilder.directBlockBuild(getAppId(), Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_2)).buildExposure("st_info_exposure_btn_alipay");//马上提现按钮曝光
        super.setDpm(DpmBuilder.directBlockBuild(getAppId(), Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_2)).buildClick("st_info_click_btn_alipay");//马上提现按钮点击
        super.setDpm(DpmBuilder.directBlockBuild(getAppId(), Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_3)).buildExposure("st_info_exposure_btn_return_activity");//返回活动按钮曝光
        super.setDpm(DpmBuilder.directBlockBuild(getAppId(), Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_3)).buildClick("st_info_click_btn_return_activity");//返回活动按钮点击

        // 首次登录页                                                                                                                    首次登录页
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_initial");//获取初始密码按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_initial");//获取初始密码按钮点击
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_2)).buildExposure("st_info_exposure_btn_register");//注册按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_2)).buildClick("st_info_click_btn_register");//注册按钮点击
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_3)).buildExposure("st_info_exposure_btn_go_login");//去登陆按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_3)).buildClick("st_info_click_btn_go_login");//去登陆按钮点击
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_4)).buildExposure("st_info_exposure_btn_go_question");//不登录有什么问题按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_4)).buildClick("st_info_click_btn_go_question");//不登录有什么问题按钮点击

        // 设置密码页                                                                                                                    设置密码页
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_2, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_go_wallet");//进入钱包按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_2, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_go_wallet");//进入钱包问题按钮点击

        // 普通登录页                                                                                                                    普通登录页
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_go_register");//立即注册按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_go_register");//立即注册按钮点击
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_2)).buildExposure("st_info_exposure_btn_find_pass");//找回密码按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_2)).buildClick("st_info_click_btn_find_pass");//找回密码按钮点击
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_3)).buildExposure("st_info_exposure_btn_login");//登陆按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_3)).buildClick("st_info_click_btn_login");//登陆按钮点击
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_4)).buildExposure("st_info_exposure_btn_go_question2");//登陆页面不登录有什么问题按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_4)).buildClick("st_info_click_btn_go_question2");//登陆页面不登录有什么问题按钮点击

        // 忘记密码页                                                                                                                    忘记密码页
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_4, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_submit");//提交按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_4, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_submit");//提交按钮点击
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_4, Constants.DPM.DPM_D_2)).buildExposure("st_info_exposure_btn_not_find");//找不到密码按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_4, Constants.DPM.DPM_D_2)).buildClick("st_info_click_btn_not_find");//找不到密码按钮点击

        // 重新获取初始密码页                                                                                                            重新获取初始密码页
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_5, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_reget_submit");//提交按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_5, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_reget_submit");//提交按钮点击
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_5, Constants.DPM.DPM_D_2)).buildExposure("st_info_exposure_btn_reget");//重新获取初始密码按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_5, Constants.DPM.DPM_D_2)).buildClick("st_info_click_btn_reget");//重新获取初始密码按钮点击

        // 钱包小贴士                                                                                                                   钱包小贴士
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_6, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_know");//朕知道了按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_6, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_know");//朕知道了按钮点击
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_6, Constants.DPM.DPM_D_2)).buildExposure("st_info_exposure_btn_know_close");//关闭按钮曝光
        super.setDpm(DpmBuilder.build(getAppId(), Constants.DPM.DPM_B_117, Constants.DPM.DPM_C_6, Constants.DPM.DPM_D_2)).buildClick("st_info_click_btn_know_close");//关闭按钮点击

        return this;
    }

}
