package com.duiba.tuia.youtui.web.embed;

import static com.duiba.tuia.youtui.web.constant.Constants.DCM.*;


/**
 * Duiba Content Monitor 兑吧内容监控
 * dcm文档：http://cf.dui88.com/pages/viewpage.action?pageId=4495707
 * a:内容类型
 * b:内容id
 * c:内容额外信息,默认0
 * d:内容子信息,默认0
 *
 * 干他奶的 dcm
 * Created by wubo on 2017/9/1.
 */
public class DcmBuilder extends DuibaMonitor {

    /**
     * 直投页广告区块
     * @param advertId 广告id
     * @param pageId 直投页id
     * @return string
     */
    public static String directBlockBuild(Long advertId,Long pageId) {
        return build(DCM_A_104,advertId,DCM_C_3,pageId);
    }

    /**
     * 直投页活动区块
     * @param activityId 活动id
     * @param pageId 直投页id
     * @return string
     */
    public static String directActivityBlockBuild(Long activityId, Long pageId) {
        return build(DCM_A_701, activityId, DCM_C_3, pageId);
    }

    /**
     * 直投页游戏区块
     * @param gameId 游戏id
     * @param pageId 直投页id
     * @return string
     */
    public static String directGameBlockBuild(Long gameId, Long pageId) {
        return build(DCM_A_1018, gameId, DCM_C_3, pageId);
    }

    /**
     * 直投页主会场区块
     * @param mainMeetId 主会场id
     * @param pageId 直投页id
     * @return String
     */
        public static String directMainMeetBlockBuild(Long mainMeetId, Long pageId) {
        return build(DCM_A_1015, mainMeetId, DCM_C_3, pageId);
    }
    /**
     * 直投页-直投页区块
     * @param mainMeetId 主会场id
     * @param pageId 直投页id
     * @return String
     */
    public static String directDirectBlockBuild(Long mainMeetId, Long pageId) {
        return build(DCM_A_1002, mainMeetId, DCM_C_3, pageId);
    }

    /**
     * 直投页-URL区块
     * @param pageId 直投页id
     * @return String
     */
    public static String directUrlBlockBuild(Long pageId) {
        return build(DCM_A_112, 0l, DCM_C_3, pageId);
    }

    /**
     * 直投页-固定区块
     * @param pageId 直投页id
     * @return String
     */
    public static String directFixedBlockBuild(Long pageId) {
        return build(DCM_A_1002, pageId, DCM_C_0, DCM_D_0);
    }

    public static String kefuBuild(Long buttonId){
        return build(DCM_A_1016,buttonId,DCM_C_1,0);
    }


    public static String pluginBuild(Long pluginId, Long activityId,Integer pageType){
        return build(DCM_A_702,pluginId,pageType,activityId);
    }

    public static String recommendBuild(int dcmA,Long id){
        return build(dcmA,id,DCM_C_0,DCM_D_0);
    }

    /**
     * 中奖公示
     *
     * @param activityId
     * @return
     */
    public static String publicNoticeBuild(Long activityId, Long publicNoticeId) {
        return build(DCM_A_703, publicNoticeId, DCM_C_1, activityId);
    }

    /**
     * 下拉推荐位
     *
     * @param activityId
     * @return
     */
    public static String pullDownBuild(Long activityId) {
        return build(DCM_A_110, DCM_B_0, DCM_C_1, activityId);
    }

    /**
     * 话费
     * @param prizeId 奖品id
     * @param pageType 页面类型(0:弹层,1:我的奖品页,2:券的详情页)
     * @param layerId
     * @return
     */
    public static String billBuild(Long prizeId, Integer pageType, Long layerId) {
        return build(DCM_A_111, prizeId, pageType, layerId == null ? 1 : layerId);
    }

    /**
     * 捕鱼游戏
     */
    public static String gameBuild(Long gameId, int c, int d) {
        return build(DCM_A_1018, gameId, c, d);
    }

    /**
     * 捕鱼排行榜关闭dcm
     */
    public static String colseRankBuild(Long gameId) {
        return build(DCM_A_1018, gameId, DCM_C_0, DCM_D_0);
    }

    /**
     * 捕鱼排行榜 券dpm
     */
    public static String advertBuild(Long advertId) {
        return build(DCM_A_104, advertId, DCM_C_6, DCM_D_1);
    }

    /**
     * 捕鱼排行榜刷新游戏dpm
     */
    public static String refreshGameBuild(Long gameId) {
        return build(DCM_A_1018, gameId, DCM_C_0, DCM_D_0);
    }

    /**
     * 捕鱼排行榜无券时知道了按钮dpm
     */
    public static String refreshKnowBuild(Long gameId) {
        return build(DCM_A_1018, gameId, DCM_C_0, DCM_D_0);
    }
}
