<!-- @format -->

# 页脚自动添加备案号

[技术方案](https://www.yuque.com/tuia/rzutr6/lckv1f)

## 开发

```shell
npm run dev:in_module
```

亦可

```shell
npm run dev:in_html
```

## 打包

```shell
npm run build
```

打包后分别输出 `IPCHelper.main.js` 和 `IPCHelper.module.js`，他们风别遵循 AMD 和 ESMD。

## 发布

### 发布到 jssdk 平台

将打包后的 `IPCHelper.main.js` 发布到 [sdk 发布平台](http://jssdk.tuia.cn/#/publish/advert)

路径： 落地页 sdk -> 发布 -> 选择 ipc-footer-sdk

### 发布到 npm

## 发布前准备工作

1. 首先确保已经登录 npm 账号并且拥有发布权限
2. 生成版本号、打 tag 和生成更改日志，其他用法详情见[standard-version](https://github.com/conventional-changelog/standard-version)

1) 指定版本号，如 0.1.0-beta

```
yarn release -- --release-as <版本号>
# Or
npm run release -- --release-as <版本号>
```

2. 不指定版本号，直接自动累加

```
yarn release
# Or
npm run release
```

成功之后把 tag 推到远程

```
git push --follow-tags origin master
```

## 发布到 npm (谨慎)

```
yarn deploy
or
npm run deploy
```

## 注意事项

如果直接使用 `npm publish --access public` 命令发布的话，发布之前要保证根目录下的 dist 包是最新的，版本号是最新的（之前没有已经发布的版本），所有代码都提交到远程 master
在发布 npm 版本之后，要执行 `npm run pub`同步最新的版本到 cdn 以便用来 script 标签引入来使用
`yarn release` 和 `yarn deploy` 是这一系列的组合命令

## TODO

- [x] elint+prettier+commit 规范代码开发&提交
- [x] standard-version 生成版本号、打 tag 和生成更改日志
- [x] 支持模块化方式导入和 script 标签方式使用

## SDK 使用

[推啊埋点 SDK 使用文档](https://www.yuque.com/docs/share/444fe742-1624-4298-937d-af8f9a14043d)
