/** @format */
type Optional<T> = { [P in keyof T]?: T[P] }

function getIPCByDomain(domain: string) {
    return new Promise((resolve, reject) => {
        resolve('1231232123')
    })
}

type IPCFooterOptions = {
    domain?: string
    dom?: HTMLElement
    footerStyles?: Optional<CSSStyleDeclaration>
    boardStyles?: Optional<CSSStyleDeclaration>
}

function addStyles(ele: HTMLElement, styles: Optional<CSSStyleDeclaration> = {}) {
    Object.entries(styles).forEach(([key, val]) => {
        ele.style[key] = val
    })
}

const defaultFooterStyles: Optional<CSSStyleDeclaration> = {
    width: '100vw',
    position: 'absolute',
    left: '0',
    right: '0',
    bottom: '0'
}
const defaultBoardStyles: Optional<CSSStyleDeclaration> = {
    display: 'inline-block',
    textDecoration: 'none',
    color: '#FFF',
    backgroundColor: 'rgba(0,0,0,.4)',
    margin: '8px auto',
    height: '28px',
    lineHeight: '28px',
    padding: '0 10px',
    borderRadius: '4px'
}

async function mountIPCFooter(opts: IPCFooterOptions) {
    const icpNumber = await getIPCByDomain(opts.domain || location.host)
    const IPCFooter = document.createElement('div')
    const IPCBoard = document.createElement('a')
    const targetDom = opts.dom || document.querySelector('body')
    IPCFooter.id = '__IPC_footer__'
    IPCBoard.id = '__IPC_board__'
    addStyles(IPCFooter, { ...defaultFooterStyles, ...(opts.footerStyles || {}) })
    addStyles(IPCBoard, { ...defaultBoardStyles, ...(opts.footerStyles || {}) })
    IPCBoard.innerText = `浙ICP备${icpNumber}号`
    IPCFooter.appendChild(IPCBoard)
    targetDom.appendChild(IPCFooter)
}

export default { getIPCByDomain, mountIPCFooter }
