/** @format */

module.exports = {
    parser: '@typescript-eslint/parser', //定义ESLint的解析器
    extends: ['prettier/@typescript-eslint', 'plugin:prettier/recommended'], //定义文件继承的子规范
    env: {
        //指定代码的运行环境
        browser: true,
        node: true
    },
    plugins: ['prettier'],
    // add your custom rules here
    rules: {
        'prettier/prettier': 'error',
        // allow async-await
        'generator-star-spacing': 0,
        // allow debugger during development
        'no-debugger': process.env.NODE_ENV === 'prod' ? 2 : 0
    }
}
