/** @format */
const path = require('path')
const HTMLWebpackPlugin = require('html-webpack-plugin')

module.exports = {
  mode: 'development',
  entry: path.resolve(__dirname, './src/index.js'),
  output: {
    filename: 'main.[contenthash].js',
    path: path.resolve(__dirname, './dist/')
  },
  devServer: {
    hot: true,
    open: true
  },
  module: {
    rules: []
  },
  plugins: [
    new HTMLWebpackPlugin({
      template: path.resolve(__dirname, './index.html'),
      filename: path.resolve(__dirname, './dist/index.html')
    })
  ]
}
