# 推啊埋点 SDK

[推啊前端埋点方案](https://www.yuque.com/docs/share/212c6065-f556-492b-a27d-748d509e3583?#)
## 开发

如果已经打包过就直接运行如下命令，开启监听，文件改动会同步打包到 dist 下

```
yarn watch
# Or 
npm run watch
```

`src/index.ts` 是入口文件，方法挂载
更改文件之后，在本地调试的时候运行如下命令，把包链接到本地

```
yarn link
# Or 
npm link
```

出现如下提示
> You can now run `yarn link "@tuia/log-sdk"` in the projects where you want to use this package and it will be used instead.

然后在需要调试的项目中（其他使用这个包的项目）`yarn link "@tuia/log-sdk"` 把本地的包链接到改项目进行调试


## 打包

打包生产环境sdk (压缩后)

```
yarn build
# Or 
npm run build
```

打包开发环境 (压缩前)方便调试

```
yarn build:debug
# Or 
npm run build:debug
```

## 发布前准备工作

1. 首先确保已经登录 npm 账号并且拥有发布权限
2. 生成版本号、打tag和生成更改日志，其他用法详情见[standard-version](https://github.com/conventional-changelog/standard-version)

1) 指定版本号，如0.1.0-beta

```
yarn release -- --release-as <版本号>
# Or 
npm run release -- --release-as <版本号>
```

2) 不指定版本号，直接自动累加

```
yarn release
# Or 
npm run release
```

成功之后把 tag 推到远程

```
git push --follow-tags origin master
```

## 发布到 npm (谨慎)

```
yarn deploy
or 
npm run deploy
```

## 注意事项
 
如果直接使用 `npm publish --access public` 命令发布的话，发布之前要保证根目录下的 dist 包是最新的，版本号是最新的（之前没有已经发布的版本），所有代码都提交到远程 master
在发布npm版本之后，要执行 `npm run pub`同步最新的版本到 cdn 以便用来script标签引入来使用
`yarn release` 和 `yarn deploy` 是这一系列的组合命令


## TODO

- [x] elint+prettier+commit 规范代码开发&提交
- [x] standard-version 生成版本号、打tag和生成更改日志
- [x] 支持模块化方式导入和script标签方式使用

## SDK 使用
[推啊埋点SDK使用文档](https://www.yuque.com/docs/share/444fe742-1624-4298-937d-af8f9a14043d)