import { ElementType } from "../enum/ElementType";
import { TargetNumber } from "./TargetNumber";

/**
 * 节日目标
 * 
 */
export class FestivalTarget extends egret.DisplayObjectContainer {
    /**
     * 打勾完成
     */
    zeroMark: egret.Bitmap;
    /**
     * 数量文案
     */
    private countNum: TargetNumber;
    /**
     * 数量
     */
    private _count: number;
    get count(): number {
        return this._count;
    }
    set count(value: number) {
        if (value <= 0) {
            value = 0;
            this.countNum.visible = false;
            this.zeroMark.visible = true;
        }
        this._count = value;
        this.countNum.num = value;
    }
    constructor(count: number = 6) {
        super()
        var texture: egret.Texture = RES.getRes("festivalTargetBg_png");
        var showImage = new egret.Bitmap(texture);
        this.addChild(showImage);
        var texture: egret.Texture = RES.getRes("rightMark_png");
        this.zeroMark = new egret.Bitmap(texture);
        this.zeroMark.x = 23;
        this.zeroMark.y = 50;
        this.zeroMark.visible = false;
        this.addChild(this.zeroMark);
        this.countNum = new TargetNumber();
        this.countNum.x = 40;
        this.countNum.y = 60;
        this.addChild(this.countNum);

        this.count = count;
    }
}