import { ElementType } from "../enum/ElementType";

//四种状态的图片，剩三种了
const images = {
    2: "ele" + ElementType.CHICKEN_EGG + "_png",
    // 2: "eggStatus2_png",
    1: "eggStatus1_png",
    0: "eggStatus0_png"
}
/**
 * 鸡蛋的状态
 * 
 */
export class ChickenEgg extends eui.Component {
    private showImage: eui.Image;
    /**
     * 是否孵小鸡
     */
    isActive: boolean;
    /**
     * 鸡蛋状态变化 2 1 0 再往后，可孵鸡
     */
    private _statusNum: number;
    get statusNum() {
        return this._statusNum
    }
    set statusNum(value: number) {
        if (value >= 0) {
            this._statusNum = value;
            //修改图片
            if (this.showImage.source != images[this._statusNum]) {
                this.changeSource(images[this._statusNum]);
            }
        } else {
            this._statusNum = 0;
            this.isActive = true;
        }
    }

    constructor(n: number = 2) {
        super()
        this.showImage = new eui.Image();
        this.addChild(this.showImage)
        this.changeSource(images[n]);

        this.isActive = false;
        this._statusNum = n;
    }
    changeSource(source: string) {
        var texture: egret.Texture = RES.getRes(source);
        this.showImage.texture = texture

        this.showImage.anchorOffsetX = texture.textureWidth / 2;
        this.showImage.anchorOffsetY = texture.textureHeight / 2 + 20;
        this.showImage.y = 20
    }
    shakeAni() {
        this.showImage.rotation = 0;
        egret.Tween.get(this.showImage)
            .to({ rotation: 10 }, 80)
            .to({ rotation: -8 }, 160)
            .to({ rotation: 5 }, 160)
            .to({ rotation: 0 }, 50)
    }


    reset(n: number = 2) {
        this.changeSource(images[n]);
        this.isActive = false;
        this._statusNum = n;

    }

}