
import getHomeData from "../getHomeData";
import { changeMapScene } from "../startScene/StartScene";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import MapScene from "../mapScene/MapScene";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";

export const gotoNextLevel = (currentLevel?) => {
    if (!currentLevel) {
        currentLevel = getHomeData().levels.length;
    }
    const onMapScene = SceneCtrl.instance.currentScene instanceof MapScene;

    if (currentLevel + 1 <= window['last_level']) {
        if (onMapScene)
            PanelCtrl.instance.show('StartPanel', currentLevel + 1)
        else
            changeMapScene({ level: currentLevel + 1 });
    }
    else {
        if (!onMapScene)
            changeMapScene();
    }
}