import { loadImageByUrl } from "../../../libs/new_wx/loadSpriteSheet";
import { DataManager } from "../../../libs/tw/manager/DataManager";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import { getPropNums } from "../../getHomeData";
import setGray from "../../setGray";
import Utils, { CouponJoinScene } from "../../Utils";
import { CurScoreNum } from "./CurScoreNum";

/**
 * 分数条的托管类，不需要继承
 */
export class ScoreProgress {
    hasOver: boolean
    starCount: number = 0;
    /**
     * 各星数的对应分数
     */
    starScores: number[];

    star1: eui.Image;
    star2: eui.Image;
    star3: eui.Image;

    starProgress: eui.Image;
    scoreTxt: CurScoreNum;
    allScore: number;
    private _score: number;
    get score() {
        return this._score
    }
    set score(value: number) {
        if (this._score == value) return
        this._score = value
        this.scoreTxt.num = Math.ceil(value);
        var diss = [
            188,
            446,
            522,
            595,
            663
        ]
        var w: number, scale: number;
        //先计算是否达到了3星
        if (value >= this.starScores[2]) {
            var aa = (value - this.starScores[2]) / (this.allScore - this.starScores[2]);
            scale = aa > 1 ? 1 : aa;
            if (scale >= 1) {
                if (!this.hasOver) {
                    this.hasOver = true;
                } else {
                    return
                }
            }
            w = (663 - 595) * scale + 595;
            if (this.star3.source != "lightedStar_png") {
                if (this.showstar[2] == 0) {
                    NetManager.ins.submitStarBox((...args) => {
                        console.error("3星宝箱获得===》", args);
                        if (args[0] && args[1]) {
                            let awardata = args[1].data;
                            if (awardata) {
                                DataManager.ins.setHomeStarData(awardata);
                                this.showstar[2] = 1;
                                this.updateStarBox(this.showstar);
                            }
                        }
                    }, this.level, 3, 1)
                }
                this.star3.source = "lightedStar_png";
                this.star2.source = "lightedStar_png";
                this.star1.source = "lightedStar_png";
                this.starCount = 3;
            };
        }
        //是否超过2星
        else if (value >= this.starScores[1]) {
            scale = (value - this.starScores[1]) / (this.starScores[2] - this.starScores[1]);
            w = (595 - 522) * scale + 522;
            if (this.star2.source != "lightedStar_png") {
                if (this.showstar[1] == 0) {
                    NetManager.ins.submitStarBox((...args) => {
                        console.error("2星宝箱获得===》", args);
                        if (args[0] && args[1]) {
                            let awardata = args[1].data;
                            if (awardata) {
                                DataManager.ins.setHomeStarData(awardata);
                                this.showstar[1] = 1;
                                this.updateStarBox(this.showstar);
                            }
                        }

                    }, this.level, 2, 1)
                }
                this.star2.source = "lightedStar_png";
                this.star1.source = "lightedStar_png";
                this.starCount = 2;
            };
        }
        //是否超过1星
        else if (value >= this.starScores[0]) {
            scale = (value - this.starScores[0]) / (this.starScores[1] - this.starScores[0]);
            w = (522 - 446) * scale + 446;
            if (this.star1.source != "lightedStar_png") {
                if (this.showstar[0] == 0) {
                    NetManager.ins.submitStarBox((...args) => {
                        console.error("1星宝箱获得===》", args);
                        if (args[0] && args[1]) {
                            let awardata = args[1].data;
                            if (awardata) {
                                DataManager.ins.setHomeStarData(awardata);
                                this.showstar[0] = 1;
                                this.updateStarBox(this.showstar);
                            }
                        }

                    }, this.level, 0, 1)
                }
                this.star1.source = "lightedStar_png";
                this.starCount = 1;
            };
        } else {
            scale = value / this.starScores[0];
            w = (446 - 188) * scale + 188;
        }
        //(466-428)/428,扩分数
        //星星
        //进度条遮罩
        var mask: any = this.starProgress.mask;
        mask.graphics.clear()
        mask.graphics.beginFill(0xff0000, 1);
        mask.graphics.drawRoundRect(0, 75, w, 48, 50)
        mask.graphics.endFill();



    }

    /**
     * 
     * @param starProgress 托管
     * @param scoreTxt 托管
     * @param starScores 
     */
    constructor(starProgress: eui.Image, scoreTxt: CurScoreNum, starScores: number[], openStarDia, level) {
        this.level = level;
        this.openStarDia = openStarDia;
        this.starProgress = starProgress;
        this.scoreTxt = scoreTxt;
        this.starScores = starScores;
        this.allScore = 466 / 428 * this.starScores[2];
        //加遮罩，加到starProgress的父级中
        var p = starProgress.parent;
        var mask = new egret.Shape();
        mask.graphics.beginFill(0xff0000, 1);
        mask.graphics.drawRoundRect(0, 75, 188, 48, 50)
        mask.graphics.endFill();
        this.starProgress.mask = mask;
        p.addChild(mask);
        //星星1   lightedStar_png
        var textureStar = RES.getRes("unlightedStar_png")
        this.star1 = new eui.Image(textureStar)
        this.star1.x = 423;
        this.star1.y = 78;
        p.addChild(this.star1);
        this.star2 = new eui.Image(textureStar);
        this.star2.x = 498;
        this.star2.y = 78;
        p.addChild(this.star2);
        this.star3 = new eui.Image(textureStar);
        this.star3.x = 573;
        this.star3.y = 76;
        p.addChild(this.star3);




        let starboxy = 25;
        let starbox1x = 423;
        let starbox2x = 498;
        let starbox3x = 573;
        this.starbox1 = new eui.Image();
        p.addChild(this.starbox1);
        this.starbox1.x = starbox1x;//-starboxwid/2;
        this.starbox1.y = starboxy;

        this.starbox2 = new eui.Image();
        p.addChild(this.starbox2);
        this.starbox2.x = starbox2x;//-starboxwid/2;
        this.starbox2.y = starboxy;

        this.starbox3 = new eui.Image();
        p.addChild(this.starbox3);
        this.starbox3.x = starbox3x;//-starboxwid/2;
        this.starbox3.y = starboxy;


        let showstar = Utils.getStarBox(level);
        this.showstar = showstar;
        this.updateStarBox(showstar);

        this.starbox1.addEventListener(egret.TouchEvent.TOUCH_TAP, this.clickStar1, this);
        this.starbox2.addEventListener(egret.TouchEvent.TOUCH_TAP, this.clickStar2, this);
        this.starbox3.addEventListener(egret.TouchEvent.TOUCH_TAP, this.clickStar3, this);
    }

    //关卡
    level = 0;
    //本关的星星宝箱显示
    showstar = [0, 0, 0];
    //新增星星宝箱
    starboxdata = [0, 0, 0];//0未开启，1待开启，2已开启
    starbox1: eui.Image;
    starbox2: eui.Image;
    starbox3: eui.Image;

    sbox1x = 423;
    sbox2x = 498;
    sbox3x = 573;
    starwid = 46;
    sboxy = 35;
    updateStarBox(data) {
        this.starboxdata = data;

        this.setboxtex(0);
        this.setboxtex(1);
        this.setboxtex(2);
    }
    s1havetween = false;
    s2havetween = false;
    s3havetween = false;

    openStarDia = null;
    async setboxtex(idx) {
        let sp: eui.Image = this["starbox" + (idx + 1)];
        let data = this.starboxdata[idx];
        let spx = this["sbox" + (idx + 1) + "x"];

        let texsrc = "starbox" + (idx + 1);
        if (data == 0) {
            texsrc += "close";
        } else if (data == 1) {
            texsrc += "";
        } else {
            texsrc += "open";
        }
        sp.texture = RES.getRes(texsrc + "_png");
        sp.anchorOffsetX = sp.width / 2;
        sp.anchorOffsetY = sp.height / 2;
        sp.x = spx + this.starwid / 2;
        sp.y = this.sboxy;
        // if(data==0){
        //     setGray(sp);
        // }else{
        //     sp.filters = [];
        // }
        if (data == 1) {
            if (!this["s" + (idx + 1) + "havetween"]) {
                this["s" + (idx + 1) + "havetween"] = true;
                egret.Tween.get(sp, { loop: true }).to({
                    rotation: 30
                }, 300)
                    .to({
                        rotation: -30
                    }, 600)
                    .to({
                        rotation: 0,
                    }, 300);
            }
        } else {
            egret.Tween.removeTweens(sp);
        }
    }
    //星星宝箱点击
    clickStar1() {
        if (this.starboxdata[0] == 1) {
            this.openStarDia && this.openStarDia(1);
        }
    }
    clickStar2() {
        if (this.starboxdata[1] == 1) {
            this.openStarDia && this.openStarDia(2);
        }
    }
    clickStar3() {
        if (this.starboxdata[2] == 1) {
            this.openStarDia && this.openStarDia(3);
        }
    }
}