import { PropNumber } from "./PropNumber";
import { PropNumShow } from "./PropNumShow";

export class PropBtnCon extends eui.Component {
    boomBtn: CusButton;
    hammerBtn: CusButton;
    stepBtn: CusButton;
    constructor() {
        super();
        this.boomBtn = new CusButton("boomBtn_png");
        this.boomBtn.x = 375 - 110 - 50  //110图片宽度，50按钮间隔
        this.addChild(this.boomBtn)
        this.hammerBtn = new CusButton("hammerBtn_png");
        this.hammerBtn.x = 375;
        this.addChild(this.hammerBtn)
        this.stepBtn = new CusButton("stepBtn_png");
        this.stepBtn.x = 375 + 110 + 50
        this.addChild(this.stepBtn)
    }
}



/**
 * 自定义按钮
 */
export class CusButton extends eui.Component {
    propNumShow: PropNumShow
    constructor(source: string) {
        super();
        this.touchChildren = false;
        var image = new eui.Image(source);
        image.x = -55;
        image.y = -55;
        this.addChild(image);
        this.propNumShow = new PropNumShow();
        this.propNumShow.x = 15;
        this.propNumShow.y = 15;
        this.addChild(this.propNumShow);

        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, () => {
            this.scaleX = this.scaleY = 0.9;
        }, this)
        this.addEventListener(egret.TouchEvent.TOUCH_END, () => {
            this.scaleX = this.scaleY = 1;
        }, this)
        this.addEventListener(egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, () => {
            this.scaleX = this.scaleY = 1;
        }, this)
    }
}