

import { State } from "../class/State";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";

/**
 * 枷锁状态
 * 动画比较简单，直接写这里
 */
export class LockState extends State {
    private showImage: egret.Bitmap;
    constructor() {
        super();
        var texture: egret.Texture = RES.getRes("lockVine_png")
        this.showImage = new egret.Bitmap(texture);
        this.addChild(this.showImage);
        this.showImage.x = -texture.textureWidth / 2;
        this.showImage.y = -texture.textureHeight / 2
    }
    reset() {
        this.alpha = 1;
    }

    //要不要把动画放在这里，这种移除动效最好统一外面，常驻动效才
    recover() {
        egret.Tween.get(this)
            .to({ alpha: 0 }, 750)
            .call(() => {
                if (this.parent) this.parent.removeChild(this);
                Pool.recover(RecoverName.LOCK_STATE, this);
            })
    }
}





// export class LockAni extends egret.DisplayObjectContainer {
//     private showImage: egret.Bitmap;
//     constructor() {
//         super()
//         var texture: egret.Texture = RES.getRes("lockVine_png")
//         this.showImage = new egret.Bitmap(texture);
//         this.addChild(this.showImage);
//         this.showImage.x = -texture.textureWidth / 2;
//         this.showImage.y = -texture.textureHeight / 2
//     }
//     /**
//      * 重置
//      */
//     reset() {
//         this.alpha = 1;
//     }
//     play(callback: Function) {
//         egret.Tween.get(this)
//             .to({ alpha: 0 }, 750)
//             .call(() => {
//                 if (this.parent) this.parent.removeChild(this);
//                 if (callback) callback();
//             })
//     }
// }



// export class LockAni extends Ani {
//     lockUp: eui.Image;
//     lockDown: eui.Image;
//     constructor() {
//         super()
//         this.aniName = "LockAni";
//         this.lockDown = new eui.Image("lockDown_png");
//         this.addChild(this.lockDown);
//         setTimeout(() => {
//             this.lockDown.x = -this.lockDown.width / 2;
//             this.lockDown.y = -this.lockDown.height / 2
//         })
//         //遮罩
//         var mask = new egret.Shape();
//         mask.graphics.beginFill(0xff0000, 1);
//         mask.graphics.drawRect(-77 / 2, -78 / 2, 77, 78)
//         mask.graphics.endFill();
//         this.addChild(mask);
//         this.lockDown.mask = mask;

//         this.lockUp = new eui.Image("lockUp_png");
//         this.addChild(this.lockUp);
//         setTimeout(() => {
//             this.lockUp.x = -this.lockUp.width / 2;
//             this.lockUp.y = -this.lockUp.height / 2
//         })
//     }
//     /**
//      * 重置
//      */
//     reset() {
//         this.alpha = 1;
//         this.lockDown.y = -78 / 2
//         // egret.Tween.removeTweens(this.lockDown);
//     }
//     play() {
//         // this.reset();
//         egret.Tween.get(this.lockDown)
//             .to({ y: -78 - 78 / 2 }, 500)
//             .call(() => {
//                 egret.Tween.get(this)
//                     .to({ alpha: 0 }, 250)
//                     .call(() => {
//                         this.recover();
//                     })
//             })
//     }
// }