import { MapData } from "./MapData";
import { PassTargetData } from "./PassTargetData";
import { ElementType } from "../enum/ElementType";

/**
 * 关卡数据接口
 * ，,注意有些带数组的数据，避免被修改，需要用slice克隆操作
 * 比如基础元素类型，定制掉落数组
 */
export interface ChapterData {
    /**
     * 地图数据
     */
    map: MapData;
    /**
     * 基础元素数量3-5，种类是否随机
     * 基础类型和ElementType一致 0到4
     */
    baseElementTypes: ElementType[];
    /**
     * 气泡生成概率0到1
     */
    bubbleProbability?: number;
    /**
     * 总步数
     */
    stepCount: number;
    /**
     * 通关目标
     */
    passTarget: PassTargetData;
    /**
     * 星数对应的分数，数组长度为3
     */
    starScores: number[];

}