import { Tool } from "../Tool";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";

/**
 * 元素出现及消失用到的矩形遮罩
 */
export class RectMask extends egret.Shape {
    constructor() {
        super();
        // this.graphics.beginFill(0xffffff);
        this.graphics.beginFill(0xff0000, 1);
        this.graphics.drawRect(-Tool.width / 2, -Tool.height / 2, Tool.width, Tool.height)
        this.graphics.endFill();
    }
    recover() {
        if (this.parent) {
            this.parent.removeChild(this);
            Pool.recover(RecoverName.RECT_MASK, this);
        }
    }
}