import { ChapterData } from "../interface/ChapterData";
import { PassType } from "../enum/PassType";
import { ElementType } from "../enum/ElementType";

/**
 * 181到200关数据
 */
export const Chapters10: ChapterData[] = [
    //181
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 27,
        passTarget: { type: 1, elements: [{ type: 9, count: 60 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                2, 3, 2, 2, 3, 2, 2, 3, 2,
                2, 3, 2, 2, 3, 2, 2, 3, 2,
                2, 3, 2, 2, 2, 2, 2, 3, 2,
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 0, 1, 0, 0, 1, 0,
                0, 1, 0, 0, 1, 0, 0, 1, 0,
                0, 1, 0, 0, 2, 0, 0, 1, 0,
                2, 2, 2, 2, 7, 2, 2, 2, 2,
                1, 2, 1, 2, 0, 2, 1, 2, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                14, 0, 53, 0, 0, 0, 53, 0, 14
            ],
            recycles: [],
            generateLats: [
                { index: 4, type: null },
                { index: 12, type: null },
                { index: 14, type: null },
                { index: 20, type: null },
                { index: 24, type: null },
                { index: 28, type: null },
                { index: 34, type: null },
                { index: 36, type: null },
                { index: 44, type: null }
            ]
        }
    },
    //182
    {
        baseElementTypes: [0, 2, 1, 3, 4],
        bubbleProbability: 0,
        stepCount: 38,
        passTarget: { type: 1, elements: [{ type: 9, count: 55 }] },
        starScores: [50001, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 0, 0, 3, 3, 3, 0, 0, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 0, 3, 3, 3, 0, 3, 3,
                3, 0, 3, 3, 3, 3, 3, 0, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 1, 1, 2, 2, 2, 1, 1, 2,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 2, 5, 5, 5, 2, 1, 1,
                1, 2, 1, 2, 2, 2, 1, 2, 1,
                5, 1, 2, 2, 2, 2, 2, 1, 5,
                5, 5, 5, 5, 5, 5, 5, 5, 5
            ],
            baseElements: [
                0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }]
        }
    },
    //183
    {
        baseElementTypes: [0, 3, 4, 2],
        bubbleProbability: 0.1,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 1, count: 30 }] },
        starScores: [5000, 18888, 43000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 4, 6, 1,
                1, 0, 0, 1, 1, 1, 4, 6, 1,
                1, 1, 1, 1, 1, 1, 4, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 4, 4, 1, 1, 1, 1, 1, 1,
                1, 2, 4, 1, 1, 1, 0, 0, 1,
                1, 2, 4, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ]
        }
    },
    //184
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 10,
        stepCount: 32,
        passTarget: { type: 1, elements: [{ type: 5, count: 44 }] },
        starScores: [5000, 11000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 1, 1, 1, 1, 1, 1, 1, 2,
                2, 5, 5, 2, 1, 2, 5, 5, 2,
                2, 1, 1, 2, 2, 2, 1, 1, 2,
                2, 5, 5, 5, 2, 5, 5, 5, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2
            ],
            recycles: [],
            generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }]
        }
    },
    //185
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.3,
        stepCount: 20,
        passTarget: { type: 1, elements: [{ type: 6, count: 6 }] },
        starScores: [5000, 20000, 30000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                2, 3, 2, 2, 2, 2, 2, 3, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 4, 1, 4, 1, 4, 1, 4, 1,
                1, 4, 1, 4, 1, 4, 1, 4, 1,
                2, 2, 2, 2, 1, 2, 2, 2, 2
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [72, 73, 74, 75, 77, 78, 79, 80],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },

                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },
                { index: 21, type: null },
                { index: 22, type: null },
                { index: 23, type: null },
            ]
        }
    },
    //186
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 25000, 40000],
        map: {
            lattices: [
                1, 1, 1, 0, 2, 0, 1, 1, 1,
                1, 1, 1, 0, 2, 0, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                0, 0, 3, 3, 3, 3, 3, 0, 0,
                3, 3, 3, 1, 3, 1, 3, 3, 3,
                0, 0, 3, 3, 3, 3, 3, 0, 0,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 0, 2, 0, 1, 1, 1,
                1, 1, 1, 0, 2, 0, 1, 1, 1
            ],
            connectedLats: [[18, 36], [19, 37], [37, 55], [25, 43], [26, 44], [43, 61]],
            elements: [
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                1, 4, 1, 7, 1, 7, 2, 4, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 22, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                21, 13, 0, 0, 0, 0, 0, 43, 31,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 4, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 21, type: null },
                { index: 23, type: null },
                { index: 54, type: null },
                { index: 62, type: null },
            ]
        }
    },
    //187
    {
        baseElementTypes: [0, 2, 1, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 65 }] },
        starScores: [5000, 30000, 50000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 6, 2, 1, 2, 1, 4, 1, 2, 1, 1, 1, 2, 1, 4, 1, 4, 1, 1, 1, 1, 1, 4, 1, 1, 1, 4, 1, 1, 1, 4, 1, 1, 1, 5, 1, 4, 1, 4, 1, 5, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //188
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 59 }] },
        starScores: [5000, 12000, 21000], map: { lattices: [0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 3, 2, 2, 2, 2, 2, 3, 0, 3, 2, 3, 2, 2, 2, 3, 2, 3, 0, 3, 2, 2, 2, 2, 2, 3, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 3, 3, 3, 2, 3, 3, 3, 0, 2, 3, 2, 3, 2, 3, 2, 3, 2, 0, 3, 3, 3, 2, 3, 3, 3, 0, 0, 0, 2, 1, 2, 1, 2, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 7, 1, 1, 1, 7, 1, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 7, 1, 7, 5, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 26, type: null }] }
    },
    //189
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0.3,
        stepCount: 23,
        passTarget: { type: 1, elements: [{ type: 1, count: 32 }, { type: 5, count: 12 }] }, starScores: [5000, 12000, 20000], map: { lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [], elements: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 6, 2, 1, 2, 6, 0, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 0, 6, 2, 1, 2, 6, 0, 1, 1, 0, 0, 1, 4, 1, 0, 0, 1, 0, 1, 1, 1, 7, 1, 1, 1, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 9, type: null }, { index: 17, type: null }, { index: 74, type: null }, { index: 78, type: null }] }
    },
    //190
    {
        baseElementTypes: [2, 3, 1, 0, 4],
        bubbleProbability: 0,
        stepCount: 1,
        passTarget: { type: 1, elements: [{ type: 0, count: 1 }] },
        starScores: [5000, 11000, 19000], map: {
            lattices: [1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0], connectedLats: [[31, 67], [45, 63], [46, 64], [47, 65], [51, 69], [52, 70], [53, 71]], elements:
                [
                    1, 1, 1, 1, 1, 1, 1, 1, 1,
                    1, 1, 1, 1, 1, 1, 1, 1, 1,
                    1, 1, 1, 1, 1, 1, 1, 1, 1,
                    1, 1, 1, 1, 1, 1, 1, 1, 1,
                    1, 1, 1, 1, 1, 1, 1, 1, 1,
                    1, 1, 1, 1, 1, 1, 1, 1, 1,
                    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }]
        }
    },
    //191
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 72 }] },
        starScores: [6000, 20000, 40000], map: { lattices: [3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3], connectedLats: [], elements: [2, 1, 2, 2, 8, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 7, 7, 7, 2, 1, 2, 8, 2, 1, 7, 7, 7, 1, 2, 8, 2, 1, 2, 7, 7, 7, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 8, 2, 2, 1, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 9, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 17, type: null }, { index: 21, type: null }, { index: 22, type: null }, { index: 23, type: null }, { index: 30, type: null }, { index: 31, type: null }, { index: 32, type: null }] }
    },
    //192 
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 1, count: 40 }, { type: 2, count: 40 }] },
        starScores: [6000, 35000, 61000],
        map: {
            lattices: [
                0, 0, 3, 0, 0, 0, 3, 0, 0,
                0, 0, 0, 3, 0, 3, 0, 0, 0,
                3, 3, 0, 0, 3, 0, 0, 3, 3,
                3, 3, 0, 0, 3, 0, 0, 3, 3,
                0, 0, 0, 0, 3, 0, 0, 0, 0,
                0, 0, 3, 0, 0, 0, 3, 0, 0,
                0, 3, 0, 3, 0, 3, 0, 3, 0,
                3, 0, 0, 0, 3, 0, 0, 0, 3,
                1, 0, 0, 0, 1, 0, 0, 0, 3
            ],
            elements: [
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 1, 2, 1, 2, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 8, 8,
                4, 4, 1, 1, 2, 1, 1, 8, 8,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 2, 1, 2, 1, 2, 1, 1,
                1, 2, 1, 2, 1, 2, 1, 2, 1,
                2, 1, 1, 1, 2, 1, 1, 1, 2,
                2, 1, 1, 1, 2, 1, 1, 1, 2
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                14, 14, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            generateLats: [
                { index: 2, cus: [14, 14] },
                { index: 6, cus: [14, 14] },
                { index: 18, type: [14, 11, 13, 31, 33, 42, 43] },
                { index: 19, type: [14, 11, 13, 31, 33, 42, 43] },
                { index: 22, cus: [14, 14, 14, 14] },
                { index: 25, type: [14, 11, 13, 31, 33, 42, 43] },
                { index: 26, type: [14, 11, 13, 31, 33, 42, 43] },
                { index: 47, cus: [14, 14, 14] },
                { index: 51, cus: [14, 14, 14] },
                { index: 63, cus: [14, 14] },
                { index: 67, cus: [14, 14] },
                { index: 71, cus: [14, 14] },
            ]
        }
    },
    //193
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 5, count: 44 }, { type: 1, count: 50 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                2, 1, 1, 1, 7, 1, 1, 1, 2,
                6, 1, 1, 2, 1, 2, 1, 1, 6,
                2, 1, 1, 2, 1, 2, 1, 1, 2,
                6, 1, 1, 2, 1, 2, 1, 1, 6,
                2, 1, 1, 1, 7, 1, 1, 1, 2,
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                2, 2, 2, 2, 1, 2, 2, 2, 2
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },

                { index: 22, type: null },

                { index: 23, type: null },
                { index: 24, type: null },
                { index: 25, type: null },
                { index: 23, type: null },

                { index: 9, type: null },
                { index: 10, type: null },
                { index: 11, type: null },
                { index: 12, type: null },

                { index: 14, type: null },
                { index: 15, type: null },
                { index: 16, type: null },
                { index: 17, type: null },

                { index: 18, type: null },
                { index: 19, type: null },
                { index: 20, type: null },
                { index: 21, type: null },
            ]
        }
    },
    //194
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 35,
        passTarget: { type: 1, elements: [{ type: 9, count: 63 }] },
        starScores: [6000, 12000, 21000],
        map: {
            lattices: [
                3, 3, 3, 0, 0, 0, 3, 3, 3,
                0, 0, 0, 3, 3, 3, 0, 0, 0,
                3, 3, 3, 0, 0, 0, 3, 3, 3,
                0, 0, 0, 3, 3, 3, 0, 0, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3
            ],
            connectedLats: [[0, 18], [1, 19], [2, 20], [18, 36], [19, 37], [20, 38], [12, 30], [13, 31], [14, 32], [6, 24], [7, 25], [8, 26], [24, 42], [25, 43], [26, 44]],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                7, 7, 7, 2, 2, 2, 7, 7, 7,
                4, 4, 7, 1, 1, 1, 7, 4, 4,
                5, 4, 7, 5, 1, 5, 7, 4, 5,
                5, 5, 1, 1, 1, 1, 1, 5, 5
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }]
        }
    },
    //195
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 9, count: 41 }] },
        starScores: [8000, 15000, 24000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                0, 3, 3, 3, 3, 3, 3, 3, 0
            ],
            connectedLats: [[27, 45], [35, 53]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 0, 0, 0, 2, 1, 1, 1, 2, 2, 0, 0, 0, 2, 2, 1, 1, 2, 0, 0, 0, 0, 0, 2, 1, 1, 2, 0, 2, 2, 2, 0, 2, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 9, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 17, type: null }]
        }
    },
    //196
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 27,
        passTarget: {
            type: 1,
            elements: [
                { type: 5, count: 10 },
                { type: 10, count: 6 },
                { type: 1, count: 100 }]
        },
        starScores: [5000, 40000, 60000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 9, 2, 6, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 2, 6, 1, 9, 1, 6, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 2, 2, 2, 6, 1, 9, 2, 1
            ],
            recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 27, type: null }, { index: 35, type: null }]
        }
    },
    //197
    {
        baseElementTypes: [4, 3, 2, 1, 0],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: 1,
            elements: [{ type: 6, count: 6 }]
        },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 0, 0, 0, 0, 0, 0, 0, 1,
                0, 1, 0, 0, 0, 0, 0, 1, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0
            ],
            elements: [
                3, 1, 1, 1, 1, 1, 1, 1, 3,
                1, 7, 1, 1, 1, 1, 1, 7, 1,
                1, 1, 7, 1, 1, 1, 7, 1, 1,
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 7, 7, 1, 7, 7, 1, 1
            ],
            recycles: [64, 70, 74, 75, 76, 77, 78],
            generateLats: [
                { index: 0, type: null },
                { index: 8, type: null },
                { index: 10, type: null },
                { index: 16, type: null },
                { index: 20, type: null },
                { index: 24, type: null },
                { index: 30, type: null },
                { index: 31, type: null },
                { index: 32, type: null }
            ]
        }
    },
    //198
    {
        baseElementTypes: [1, 0, 2, 3, 4],
        bubbleProbability: 0.3,
        stepCount: 22,
        passTarget: { type: 1, elements: [{ type: 9, count: 23 }] },
        starScores: [5000, 13000, 33000],
        map: {
            lattices: [1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 2, 0, 2, 0, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0], connectedLats: [], elements: [7, 1, 1, 1, 7, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 4, 1, 1, 1, 4, 4, 1, 1, 1, 4, 1, 1, 1, 4, 4, 1, 1, 1, 4, 1, 1, 1, 4, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 4, type: null }, { index: 8, type: null }]
        }
    },
    //199
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 28,
        passTarget: {
            type: 1,
            elements: [{ type: 6, count: 5 }]
        },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 1, 0, 1, 0, 1, 0, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 3, 1, 1, 1, 1,
                3, 1, 1, 1, 1, 1, 1, 1, 3,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 4, 2, 4, 2, 4, 2, 4, 2,
                2, 4, 2, 4, 2, 4, 2, 4, 2,
                2, 4, 2, 4, 2, 4, 2, 4, 2,
                2, 1, 2, 1, 2, 1, 2, 1, 2
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [64, 66, 68, 70, 72, 74, 76, 78, 80],
            generateLats: [
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 9, type: null },
                { index: 17, type: null }
            ]
        }
    },
    //200
    {
        baseElementTypes: [0, 3, 2, 4],
        bubbleProbability: 0,
        stepCount: 33,
        passTarget: { type: 1, elements: [{ type: 1, count: 20 }] },
        starScores: [8000, 21000, 35000],
        map: { lattices: [0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0], connectedLats: [[38, 56], [39, 57], [41, 59], [42, 60]], elements: [1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 7, 4, 4, 4, 7, 1, 1, 1, 1, 7, 7, 7, 7, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 41, 0, 41, 42, 0, 0], recycles: [], generateLats: [{ index: 4, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 19, type: null }, { index: 25, type: null }, { index: 27, type: null }, { index: 28, type: null }, { index: 34, type: null }, { index: 35, type: null }] }
    }
]