import { ImageAni } from "../class/ImageAni";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { playSound, SoundType } from "../../soundCtrl";
import { Tool } from "../Tool";
import { ElementType } from "../enum/ElementType";
import { Element } from "../class/Element";

/**
 * 需要回调的
 * 
 */
export class JellySpreadAni extends egret.DisplayObjectContainer {
    //原位置的图片
    oriImage: egret.Bitmap;
    //目标位置的图片，到时根据方向定
    targetImage: egret.Bitmap;

    shoot: egret.Bitmap;
    constructor() {
        super()
        var texture: egret.Texture = RES.getRes("ele" + ElementType.JELLY + "_png")
        this.targetImage = new egret.Bitmap(texture);
        this.targetImage.anchorOffsetX = texture.textureWidth / 2;
        this.targetImage.anchorOffsetY = texture.textureHeight / 2;
        this.addChild(this.targetImage);

        this.oriImage = new egret.Bitmap(texture);
        this.oriImage.anchorOffsetX = texture.textureWidth / 2;
        this.oriImage.anchorOffsetY = texture.textureHeight / 2;
        this.addChild(this.oriImage);

        this.shoot = new egret.Bitmap(RES.getRes("jellyArrow_png"));
        this.shoot.anchorOffsetX = 0;
        this.shoot.anchorOffsetY = 23 / 2;
        this.addChild(this.shoot);
    }

    play(startP: number[], cloneEle: Element, callback: Function) {
        this.x = startP[0];
        this.y = startP[1];
        //终点位置全局先赋值出来，判断用
        var endP = [cloneEle.x, cloneEle.y];
        //添加进
        this.addChildAt(cloneEle, 0);


        this.shoot.visible = true;
        this.shoot.x = 0
        this.shoot.y = 0;
        this.shoot.scaleX = this.shoot.scaleY = 0.01;
        this.targetImage.visible = false;
        //判断上下左右，
        var obj = { scaleX: 0.01, scaleY: 0.01, x: 0, y: 0 };
        //x相等 上下
        if (Math.abs(endP[0] - startP[0]) <= 0.001) {
            //下
            if (endP[1] - startP[1] > 0) {
                this.shoot.rotation = 90;
                this.targetImage.x = 0;
                this.targetImage.y = Tool.height;
                obj.y = Tool.height;
            }
            //上
            else {
                this.shoot.rotation = 270;
                this.targetImage.x = 0;
                this.targetImage.y = -Tool.height;
                obj.y = -Tool.height;
            }
        }
        //y相等 左右
        else {
            //左
            if (endP[0] - startP[0] > 0) {
                this.shoot.rotation = 0;
                this.targetImage.x = Tool.width;
                this.targetImage.y = 0;
                obj.x = Tool.width;
            }
            //右
            else {
                this.shoot.rotation = 180;
                this.targetImage.x = -Tool.width;
                this.targetImage.y = 0;
                obj.x = -Tool.width;
            }
        }
        //cloneEle的位置赋值
        cloneEle.x = this.targetImage.x;
        cloneEle.y = this.targetImage.y;

        egret.Tween.get(this.oriImage)
            .to({ scaleX: 1.07, scaleY: 0.89 }, 150)
            .to({ scaleX: 0.91, scaleY: 1.07 }, 150)
            .to({ scaleX: 1.07, scaleY: 0.89 }, 100)
            .to({ scaleX: 0.93, scaleY: 1.06 }, 100)
            .to({ scaleX: 1.07, scaleY: 0.93 }, 100)
            .to({ scaleX: 1, scaleY: 1 }, 100)

        egret.Tween.get(this.shoot)
            .to({ scaleX: 2, scaleY: 1 }, 230)
            .to(obj, 50)
            .call(() => {
                //回收克隆元素
                this.removeChild(cloneEle);
                Pool.recover(RecoverName.ELEMENT, cloneEle)
                //回调
                callback();
                this.shoot.visible = false;
                this.targetImage.visible = true;
                egret.Tween.get(this.targetImage)
                    .to({ scaleX: 1.07, scaleY: 0.89 }, 150)
                    .to({ scaleX: 0.91, scaleY: 1.07 }, 150)
                    .to({ scaleX: 1.07, scaleY: 0.89 }, 100)
                    .to({ scaleX: 0.93, scaleY: 1.06 }, 100)
                    .to({ scaleX: 1.07, scaleY: 0.93 }, 100)
                    .to({ scaleX: 1, scaleY: 1 }, 100)
                    .call(() => {
                        if (this.$parent) {
                            this.$parent.removeChild(this)
                        };
                        Pool.recover(RecoverName.JELLYSPREAD_ANI, this)
                    })
            })
    }
}