import { Tool } from "../Tool";
import { ElementType } from "../enum/ElementType";
import { EffectType } from "../enum/EffectType";
import { Element } from "../class/Element";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";

/**
 * 矩形遮罩的元素动画
 * @param eleC 
 * @param p 
 * @param con 
 * @param callback 
 */
export function EleMaskAni(
    eleC: Element,
    p: number[],
    wait: number,
    con: egret.DisplayObjectContainer,
    isUp: boolean = false,
    deltaTime:number,
    callback?: Function
) {
    let ele = Tool.getElement(eleC.type);
    ele.effectType = eleC.effectType;
    ele.x = p[0];
    ele.y = p[1] - Tool.height * (isUp ? 0 : 1);
   

    let mask = Tool.getRectMask();
    mask.x = p[0];
    mask.y = p[1];
    ele.mask = mask;
    con.addChild(mask);

    egret.Tween.get(ele)
        .wait(wait)
        .call(()=>{
            con.addChild(ele);
        })
        .to({ x: p[0], y: p[1] + Tool.height * (isUp ? 1 : 0) }, deltaTime)
        .call(() => {
            //回收元素
            con.removeChild(ele);
            Pool.recover(RecoverName.ELEMENT, ele);
            //回收遮罩
            ele.mask = null;
            mask.recover();
            //回调
            callback && callback();
        })
}