import { Ani } from "../class/Ani";

const offsetX = 91 / 2;
const offsetY = 62 / 2;

export class EggBrokenAni extends Ani {

    downCircle: egret.Bitmap;
    upCircle: egret.Bitmap;
    eggPiece1: egret.Bitmap;
    eggPiece2: egret.Bitmap;
    eggPiece3: egret.Bitmap;
    eggPiece4: egret.Bitmap;
    eggPiece5: egret.Bitmap;
    constructor() {
        super()
        this.aniName = "EggBrokenAni";

        var arr = ["yellowCircleDown_png", "yellowCircleUp_png", "eggPiece1_png", "eggPiece2_png", "eggPiece3_png", "eggPiece4_png", "eggPiece5_png"];
        var objs = ["downCircle", "upCircle", "eggPiece1", "eggPiece2", "eggPiece3", "eggPiece4", "eggPiece5"];

        for (var i = 0; i < arr.length; i++) {
            var texture: egret.Texture = RES.getRes(arr[i])
            var obj = new egret.Bitmap(texture);
            this.addChild(obj);
            obj.anchorOffsetX = texture.textureWidth / 2;
            obj.anchorOffsetY = texture.textureHeight / 2;
            this[objs[i]] = obj;
        }
    }

    play() {
        this.alpha = 1;
        //黄色圈下
        egret.Tween.get(this.downCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .to({ scaleX: 0.6, scaleY: 0.6 }, 300, egret.Ease.cubicOut)
        egret.Tween.get(this.downCircle)
            .set({ alpha: 1 })
            .wait(140)
            .to({ alpha: 0 }, 160);
        //黄色圈上
        egret.Tween.get(this.upCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .wait(70)
            .to({ scaleX: 1, scaleY: 1 }, 160, egret.Ease.cubicOut);
        egret.Tween.get(this.upCircle)
            .set({ alpha: 1 })
            .wait(170)
            .to({ alpha: 0 }, 100);
        //下面所有的蛋壳碎片
        egret.Tween.get(this.eggPiece1)
            .set({ rotation: 0, x: 37 - offsetX, y: 22 - offsetY })
            .to({ rotation: 60, x: 37 - offsetX - 30, y: 22 - offsetY - 34 }, 400);
        egret.Tween.get(this.eggPiece2)
            .set({ rotation: 0, x: 48 - offsetX, y: 20 - offsetY })
            .to({ rotation: 60, x: 48 - offsetX + 36, y: 20 - offsetY - 28 }, 400);
        egret.Tween.get(this.eggPiece3)
            .set({ rotation: 0, x: 52 - offsetX, y: 32 - offsetY })
            .to({ rotation: 60, x: 52 - offsetX + 30, y: 32 - offsetY + 10 }, 400);
        egret.Tween.get(this.eggPiece4)
            .set({ rotation: 0, x: 45 - offsetX, y: 44 - offsetY })
            .to({ rotation: 60, x: 45 - offsetX + 32, y: 44 - offsetY + 38 }, 400);
        egret.Tween.get(this.eggPiece5)
            .set({ rotation: 0, x: 34 - offsetX, y: 34 - offsetY })
            .to({ rotation: 60, x: 34 - offsetX - 20, y: 34 - offsetY + 14 }, 400);

        //整体透明度
        egret.Tween.get(this)
            .wait(250)
            .to({ alpha: 0 }, 150)
            .call(() => {
                this.recover();
            })


    }


}