import Panel from "../../libs/new_wx/components/Panel";
import getSkinPath from "../../libs/new_wx/utils/getSkinPath";
import { HtmlTextParser } from "../../libs/new_wx/HtmlTextParser";

/**
 * 邀请规则面板
 */
export default class RedBombRule extends Panel {
    public scroller: eui.Scroller;
    public group: eui.Group;
    public labContent: eui.Label;
    public closeBtn: eui.Button;
    private _mask: egret.Sprite;

    start() {
        super.start();
        this.addRule();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, ()=>{
            this.visible = false;
        }, this);
    }

    loadSkin() {
        this.skinName = getSkinPath(this.skinKey);
        if (this.skin) {
            this.onSkinComplete();
        } else {
            this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        }
    }

    private addRule() {
        const text = 
        `<br>1、用户每天邀请指定数量的新玩家参与闯关，可获得指定的现金券奖励。
2、用户发起邀请后，需在24小时内完成邀请任务；超过24小时，邀请任务失败，无法获得奖励，需重新发起邀请。
3、新用户仅包含未参与过狮狮连萌活动的用户。
4、用户不可为自己助力，或重复为好友助力。
5、完成邀请任务后，玩家可点击首页“邀请得现金券”图标领取现金券。
6、发放的奖励请在规定的有效时间内尽快领取或使用，逾期未领取或使用的会失效哦。
7、活动过程中，凡以不正当手段（包括但不限于作弊、恶意套现、扰乱系统、网络攻击等违规行为）参与本次活动的用户，苏宁易购有权终止其参加活动，并取消其获得奖励的资格。
8、极少数特殊情况下，若用户在完成活动的任务中被系统判定异常账户或风控账户，则可能导致奖励发放异常。
9、如遇不可抗力（包括但不限于重大自然灾害事件、活动受政府机关指令需要停止举办或调整的、活动遭受严重网络攻击不能正常进行的），苏宁易购有权取消、修改或暂停活动。`
        this.labContent.textFlow = (new HtmlTextParser).parser(text);
    }

    get skinKey() {
        return 'RedBombRule'
    }
}
