import Panel from "../../libs/new_wx/components/Panel";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import { NetManager } from "../../libs/tw/manager/NetManager";
import getHomeData, { BLOOD_NUMS_MAX } from "../getHomeData";
import { PropNumber } from "../something/uis/PropNumber";
import Utils, { VideoEntranceScene } from "../Utils";

export default class AddBloodV extends Panel {
    start(data) {
        super.start();

        let propNumShow = new PropNumber();
        this["stepcountgro"].addChild(propNumShow);
        propNumShow.num = 5;
        propNumShow.x = 22.5;
        propNumShow.y = 7;

        propNumShow.scaleX = 1.5;
        propNumShow.scaleY = 1.5;
    }

    initEvents() {
        super.initEvents();
        this['videoBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTapBuy, this)
    }

    onTapBuy() {
        this['videoBtn'].enabled = false;
        Utils.showVideo(VideoEntranceScene.life,(suc) => {
            this['videoBtn'].enabled = true;
            if (suc) {
                NetManager.ins.hc_home(() => {
                    SceneCtrl.instance.updateScene();
                }, window['collectRuleId']);
                this.hidePanel();
            } else {
                showToast("广告未成功观看，无法获得体力");
            }
        })
        // NetManager.ins.hc_exchange((success, res) => {
        //     this['videoBtn'].enabled = true;
        //     if (success) {
        //         showToast('兑换成功');
        //         NetManager.ins.hc_home(() => {
        //             SceneCtrl.instance.updateScene();
        //         }, window['collectRuleId']);
        //     }
        //     else if (res) {
        //         showToast(res.desc || "网络异常")
        //     } else {
        //         showToast("网络异常，请重试")
        //     }
        // }, 1);
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    get skinKey() { return 'AddBloodV' }
}