import ComponentBase from "../../libs/new_wx/components/ComponentBase";
import MapScene from "./MapScene";
import MapStarComp from "./MapStarComp";
import { createData } from "../startScene/StartScene";

export default class MapTopPart extends ComponentBase {
    static LEVEL_NUMS = 7;
    start() {
        super.start();
        for (let i = 0; i < MapTopPart.LEVEL_NUMS; i++) {
            const levelOrder = i + 1;
            const icon = MapScene.iconHash[levelOrder] = this.getIcon(i);
            // const label:eui.BitmapLabel=icon.getChildAt(1) as eui.BitmapLabel;
            
            const star = new MapStarComp(levelOrder);
            star.loadSkin(); star.start();
            MapScene.starHash[levelOrder] = star;
            icon.addChild(star);
            
            icon['nums']  = icon.getChildAt(0);
            icon['bmptxt']=icon.getChildAt(1);
            this.removeChild(icon);icon.hide = ()=>{this.removeChild(icon)};
            icon['mappart']=this;
            icon.show = ()=>{this.addChild(icon)};
            icon['visibleY'] = icon.y;
            // console.log(icon['visibleY']);
        }
    }

    getIcon(i) { return this[`icon${i}`]; }

    get skinKey(): string { return 'MapTop' }
}