import ComponentBase from "../../libs/new_wx/components/ComponentBase";
import Utils, { CouponJoinScene } from "../Utils";

export default class MapStarComp extends ComponentBase {
    constructor(level){
        super();
        this.level = level;
    }
    level:number;
    start() {
        super.start();
        this.x = 15;
        this.y=-24;
        
        this.setStar(0);


        this['starlbox1'].addEventListener(egret.TouchEvent.TOUCH_TAP, (e)=>{
            e.stopPropagation();
            this.openStarDia(1);
        }, this)
        this['starlbox2'].addEventListener(egret.TouchEvent.TOUCH_TAP, (e)=>{
            e.stopPropagation();
            this.openStarDia(2);
        }, this)
        this['starlbox3'].addEventListener(egret.TouchEvent.TOUCH_TAP, (e)=>{
            e.stopPropagation();
            this.openStarDia(3);
        }, this)
    }
     //星星宝箱开启
     openStarDia(staridx){
        Utils.couponJoin(CouponJoinScene["StarBox" + staridx],this.level,()=>{

        },()=>{
            
        });
    }
    setStar(num:number)
    {
        this['star1'].visible=false;
        this['star2'].visible=false;
        this['star3'].visible=false;

        if(num ==0) {
            
        }else if(num ==1) {
            this['star1'].visible=true;
        }
        else if(num ==2) {
            this['star2'].visible=true;
        }else if(num ==3) {
            this['star3'].visible=true;
        }
    }
    //0：未拥有，1：未开，2：开了
    setBox(showstar){
        let idx = 0;
        for(let i=0;i<showstar.length;i++){
            let idata = showstar[i];
            if(idata==1){
                idx = i;
                break;
            }
        }
        
        this['starlbox1'].visible = false;
        this['starlbox2'].visible = false;
        this['starlbox3'].visible = false;

        this["boxinfogro"].visible = true;
        if(idx ==0) {
            this["boxinfogro"].visible = false;
        }else if(idx ==1) {
            this['starlbox1'].visible=true;
        }
        else if(idx ==2) {
            this['starlbox2'].visible=true;
        }else if(idx ==3) {
            this['starlbox3'].visible=true;
        }
    }
    get skinKey(): string { return 'Star' }
}