import ComponentBase from "../../libs/new_wx/components/ComponentBase";
import MapTopPart from "./MapTopPart";
import MapScene from "./MapScene";
import MapStarComp from "./MapStarComp";
import { createData } from "../startScene/StartScene";

export default class MapRpeatPart extends ComponentBase {
    static LEVEL_NUMS = 13;
    private _index;
    private _topHeight;
    constructor(i,topHeight) {
        super();
        this._index = i;
        this._topHeight=topHeight;
    }

    start() {
        super.start();
        for (let i = 0; i < MapRpeatPart.LEVEL_NUMS; i++) {
            const levelOrder = MapTopPart.LEVEL_NUMS + this._index * MapRpeatPart.LEVEL_NUMS + i + 1;
            this.getTxt(i).text = levelOrder + '';
            
            
            const icon = MapScene.iconHash[levelOrder] = this.getIcon(i);
            this.removeChild(icon);
            icon.show = ()=>{this.addChild(icon)};
            icon.hide = ()=>{this.removeChild(icon)};
            icon['nums']  = icon.getChildAt(0);
            icon['bmptxt']=icon.getChildAt(1);
            icon['mappart']=this;

            const star = new MapStarComp(levelOrder);
            star.loadSkin(); star.start();
            MapScene.starHash[levelOrder] = star;
            icon.addChild(star);
            icon['visibleY'] = this._topHeight + this.height * this._index + icon.y;
            // console.log(icon['visibleY'] );
        }

    }

    getIcon(i) { return this[`icon${i}`]; }
    getTxt(i): eui.BitmapLabel { return this[`txt${i}`]; }

    get skinKey(): string { return 'MapRepeat' }
}