import ComponentBase from "../../libs/new_wx/components/ComponentBase";
import MapScene from "./MapScene";
import MapStarComp from "./MapStarComp";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import setGray from "../setGray";
import MapTopPart from "./MapTopPart";
import MapRpeatPart from "./MapRpeatPart";
import { getRepeatCount } from "../startScene/StartScene";

export default class MapBottomPart extends ComponentBase {
    static LEVEL_NUMS = 11;
    getTxt(i): eui.BitmapLabel { return this[`txt${i}`]; }
    start({repeatHeight,topHeight}) {
        super.start();
        const repeatCount =getRepeatCount();
        for (let i = 0; i < MapBottomPart.LEVEL_NUMS; i++) {
            const levelOrder = MapTopPart.LEVEL_NUMS + MapRpeatPart.LEVEL_NUMS * repeatCount + i +1;
            this.getTxt(i).text = levelOrder + '';
        }

        for (let i = 0; i < MapBottomPart.LEVEL_NUMS; i++) {
            const levelOrder = i + 1 + (window['total_level'] - MapBottomPart.LEVEL_NUMS);
            if ( levelOrder > window['last_level']) {
                setGray(this.getIcon(i));
                this.getIcon(i).addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                    showToast('敬请期待更多关卡~');
                }, this);

            }
            
            const icon = MapScene.iconHash[levelOrder] = this.getIcon(i);
            this.removeChild(icon);
            icon.show = ()=>{this.addChild(icon)};
            icon.hide = ()=>{this.removeChild(icon)};
            icon['nums']  = icon.getChildAt(0);
            icon['bmptxt']=icon.getChildAt(1);
            icon['mappart']=this;
            
            const star = new MapStarComp(levelOrder);
            star.loadSkin(); star.start();
            MapScene.starHash[levelOrder] = star;
            icon.addChild(star);
            icon['visibleY'] = icon.y + topHeight + repeatHeight * repeatCount;
        }
    }

    getIcon(i) { return this[`icon${i}`]; }
    get skinKey(): string { return 'MapBottom' }
}