import MovieClip from "../movieclip/MovieClip";

export const createEffect1MovieClip = () => {
    const spritesheet = RES.getRes('effect1_json');
    const list = getEffectFramesStr('红包爆炸_000', 0, 18);

    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 2,
        frames: list,
        position: [750 / 2, 750 - 100],
        scale: 1,
        anchor: [.5, .5],
        loop: false
    });
    movieclip.once(egret.Event.COMPLETE, () => {
        if (movieclip.parent)
            movieclip.parent.removeChild(movieclip);
    }, this)
    return movieclip
}

const getNumStr = (num) => {
    return num >= 10 ? `${num}` : `0${num}`;
}

export const getEffectFramesStr = (str, start, end) => {
    const list = [];
    for (let index = start; index <= end; index++) {
        list.push(str + getNumStr(index));
    }
    return list;
}