import AdVideo from './video-core/index';
import loadingPlugin from './video-core/videoPlugin/loadingPlugin/index';
import videoControlPlugin from './video-core/videoPlugin/videoControl/index';
import footerPagePlugin from './video-core/videoPlugin/footerPagePlugin/index';
import landPagePlugin from './video-core/videoPlugin/landPagePlugin/index';
import MobileDetect from './video-core/mobile-detect';

const getUrlParameter = (name, path = window.location.href) => {
  const result =
    decodeURIComponent(
      (new RegExp('[?|&]' + name + '=([^&;]+?)(&|#|;|$)').exec(path) || [undefined, ''])[1].replace(/\+/g, '%20')
    ) || null;
  return result;
};

const reflectObj = {
  wifi: 1,
  '2g': 2,
  '3g': 3,
  '4g': 4,
  '5g': 5,
  other: 6
};

function getNetworkType(obj = reflectObj) {
  const ua = navigator.userAgent;
  let networkStr = ua.match(/NetType\/\w+/) ? ua.match(/NetType\/\w+/)[0] : 'NetType/other';
  networkStr = networkStr.toLowerCase().replace('nettype/', '');
  let networkType;
  switch (networkStr) {
    case 'wifi':
      networkType = 'wifi';
      break;
    case '4g':
      networkType = '4g';
      break;
    case '3g':
      networkType = '3g';
      break;
    case '3gnet':
      networkType = '3g';
      break;
    case '2g':
      networkType = '2g';
      break;
    default:
      networkType = 'other';
  }
  if (obj[networkType]) {
    return obj[networkType];
  }
  return networkType;
}


const reportGet = (e) => {
  const img = new Image();
  img.src = e;
};

AdVideo.install(loadingPlugin);
AdVideo.install(videoControlPlugin);
AdVideo.install(footerPagePlugin);
AdVideo.install(landPagePlugin);

function replaceUrl(url, replaceConfig) {
  for (const i in replaceConfig) {
    if (replaceConfig[i]) {
      url = url.replace(i, replaceConfig[i]);
    }
  }
  return url;
}

function replaceMacro1(url, mouseE) {
  const x = mouseE.screenX;
  const y = mouseE.screenY;
  const point = JSON.stringify({
    down_x: x,
    down_y: y,
    up_x: x,
    up_y: y
  });
  const encodeP = encodeURI(point);
  return replaceUrl(url, {
    __ABSOLUTE_COORD__: point,
    __RELATIVE_COORD__: point,
    '{ABSOLUTE_COORD}': encodeP,
    '{RELATIVE_COORD}': encodeP,
    '{UUID}': defaultConfig.imei || defaultConfig.idfa,
  });
}

function replaceMacro2(url, mouseE,
  { responseTime = '', readyTime = '', showTime = '', clickTime = '' }) {
  const x = mouseE.screenX;
  const y = mouseE.screenY;
  return replaceUrl(url, {
    __RESPONSE_TIME__: responseTime,
    __READY_TIME__: readyTime,
    __SHOW_TIME__: showTime,
    __CLICK_TIME__: clickTime,
    __DOWN_X__: x,
    __DOWN_Y__: y,
    __UP_X__: x,
    __UP_Y__: y,
    __WIDTH__: x,
    __HEIGHT__: y
  });
}
const getUrl = (name) => {
  return getUrlParameter('_ext_' + name);
};
// const contanier = document.querySelector('.ad-video-player');
// const player = new AdVideo({
//   el: contanier
// });
// player.emit('$footerPageChangeApp', {
//   name: '测试app',
//   appIcon: 'https://yun.dui88.com/ecb_v2_pdd2_icon.png',
//   starNum: 4,
//   commentNum: 6800,
//   buttonText: '测试按钮'
// });
// player.emit('$landPageChangeApp', {
//   name: '测试app',
//   appIcon: 'https://yun.dui88.com/ecb_v2_pdd2_icon.png',
//   starNum: 4,
//   commentNum: 6800,
//   buttonText: '测试按钮'
// });
// player.on('$footerPageClick', () => {
//   console.log('xxx');
// });
// player.load('https://yun.dui88.com/ecb_vz2_tjj_mp.mp4');

let defaultConfig;
function getDefaultConfig() {
  if (defaultConfig) return defaultConfig;
  defaultConfig = {};
  // defaultConfig = {
  //   'ost':1,
  //   "slotid":"1007",
  //   'osv': '9.1.0',
  //   'bundle': 'com.mechat.api',
  //   "appv":"9.1.0",
  //   "devt":1,
  //   "vendor":"HUAWEI",
  //   "model":"EML-AL00",
  //   "idfa":"",
  //   "imei":"866774045494393",
  //   "imsi":"",
  //   "androidid":"clb7n19124002087",
  //   "mac":"02:00:00:00:00:00",
  //   "sw":1080,
  //   "sh":2244,
  //   "ppi":1,
  //   "opert":3,
  //   "connt":4,
  //   "adw":100,
  //   "adh":100,
  //   "type":3,
  //   "ipv4":"115.236.166.122",
  // };
  const md = new MobileDetect(window.navigator.userAgent);
  if (md.os() === 'iOS') {
    defaultConfig.ost = 2;
    defaultConfig.idfa = getUrl('idfa');
    defaultConfig.ppi = Math.min(window.devicePixelRatio, 3);
    defaultConfig.model = getUrl('model') || md.versionStr('Version');
    defaultConfig.osv = getUrl('osv') || md.version('Ios');
    defaultConfig.idfa = '';
  } else {
    defaultConfig.ost = 1;
    defaultConfig.imei = getUrl('imei') || getUrlParameter('deviceId');
    defaultConfig.ppi = 1;
    defaultConfig.model = getUrl('model') || md.versionStr('Build');
    defaultConfig.osv = getUrl('osv') || md.version('Android').toString();
    defaultConfig.androidid = getUrl('androidid') || '';
    defaultConfig.imsi = getUrl('imsi') || '';
  }
  defaultConfig.mac = getUrl('mac') || '02:00:00:00:00:00';
  defaultConfig.sw = document.body.clientWidth;
  defaultConfig.sh = document.body.clientHeight;
  defaultConfig.opert = getUrl('opert') || 0;
  defaultConfig.connt = getUrl('connt') || getNetworkType();
  defaultConfig.vendor = getUrl('vendor') || md.phone();
  defaultConfig.devt = 1;
  defaultConfig.bundle = getUrl('bundle');
  defaultConfig.appv = getUrl('appv');
  defaultConfig.adw = 580;
  defaultConfig.adh = 90;
  return defaultConfig;
}

class MyAdvideo {
  videoReady: boolean;
  el: any;
  player: AdVideo;
  _responseTime: any;
  _readyTime: any;
  _showTime: any;
  showReport: any[];
  appContent: {};
  url: string;
  isFirstClick: boolean;
  process25: boolean;
  process50: boolean;
  process75: boolean;
  landpage: any;
  videoRaw: {};
  playResolve: any;
  playPromise: Promise<{}>;
  playReport: any
  macro: any;
  constructor(config) {
    this.videoReady = false;
    this.el = config.el;
    this.hide();
    this.player = new AdVideo(config);
    this.reset();
    this.initListener();
  }

  // 重置一些状态
  reset() {
    // 视频是否准备好了。
    this.videoReady = false;
    // 响应完成时间
    this._responseTime = null;
    // 素材load时间
    this._readyTime = null;
    // 展示时间
    this._showTime = null;
    // 曝光地址
    this.showReport = [];
    // 下载包名信息
    this.appContent = {};
    // 视频地址
    this.url = '';
    // 第一次点击
    this.isFirstClick = true;
    // 播放 25%;
    this.process25 = false;
    // 播放 50%;
    this.process50 = false;
    // 播放 100%;
    this.process75 = false;
    this.landpage = null;
    this.videoRaw = {};
    // 视频播放的 Promise
    this.playResolve = null;
    this.playPromise = new Promise((resolve) => {
      this.playResolve = resolve;
    });
  }

  // 请求完成
  initListener() {
    this.player.on('play', () => {
      this._readyTime = +new Date();
      if (this.player.$video.currentTime === 0) {
        this._showTime = +new Date();
        this.initShowReport();
        this.reportShow();
        console.log(this.playReport);
        if (this.playReport["playStart"]) {
          this.playReport["playStart"].forEach(e => {
            reportGet(e);
          });
        };
      }
    });
    this.player.on('$footerPageClick', (e) => {
      this.reportClick(e);
    });
    this.player.on('$porcess', (e) => {
      if (e > 25 && this.playReport["process25"] && !this.process25) {
        this.playReport["process25"].forEach(e => {
          reportGet(e);
        });
      };
      if (e > 50 && this.playReport["process50"] && !this.process50) {
        this.playReport["process50"].forEach(e => {
          reportGet(e);
        });
      }
      if (e > 75 && this.playReport["process75"] && !this.process75) {
        this.playReport["process75"].forEach(e => {
          reportGet(e);
        });
      }
    });
    this.player.on('ended', () => {
      this.playReport["playEnd"].forEach(e => {
        reportGet(e);
      });
      this.playResolve();
    });
    this.player.on('$videoClose', () => {
      this.hide();
    });
  }

  // 请求视频的来源
  async getVideo(type) {
    console.log('获取video');
    return new Promise((resolve) => {
      window.fetch('/commercialloanv/richMan/rewardVideo', {
        body: JSON.stringify(
          Object["assign"](
            { type }, getDefaultConfig())
        ),
        headers: {
          'content-type': 'application/json'
        },
        method: 'POST'
      }).then(res => {
        return res.json();
      }).then(res => {
        if (res.code === '0000000' && res.data.rewardVideoVo && res.data.rewardVideoVo.rewardvideo) {
          this.macro = res.data.rewardVideoVo.macro;
          this._responseTime = +new Date();
          this.videoRaw = res.data.rewardVideoVo;
          this.initVideo(this.videoRaw);
          this.initVideoPlayReport(this.videoRaw);
          this.videoReady = true;
          console.log('获取video 成功');
          resolve(true);
        } else {
          this.videoReady = false;
          resolve(false);
        }
      }).catch(err => {
        this.videoReady = false;
        console.log(err);
        resolve(false);
      });
    });
  }

  // 曝光上报
  reportShow() {
    this.showReport.forEach(e => {
      reportGet(e);
    });
  }

  // 曝光上报
  initShowReport() {
    if (this.macro === 0 || this.macro === 1) {
      this.showReport = this.videoRaw["shownotice"] || [];
    } else if (this.macro === 2) {
      this.showReport = (this.videoRaw["shownotice"] || []).map(e => {
        return replaceUrl(e, {
          __RESPONSE_TIME__: this._responseTime,
          ____READY_TIME__: this._readyTime,
          __SHOW_TIME__: this._showTime,
          __WIDTH__: document.body.clientWidth,
          __HEIGHT__: document.body.clientHeight
        });
      });
    }
  }

  async reportClick(event) {
    if (this.macro === 0) {
      (this.videoRaw["clicknotice"] || []).forEach(e => {
        reportGet(e);
      });
      this.landpage = this.videoRaw["landingpage"];
    } else if (this.macro === 1) {
      const clicknotice = (this.videoRaw["clicknotice"] || []).map(e => {
        return replaceMacro1(e, event);
      });
      this.landpage = replaceMacro1(this.videoRaw["landingpage"], event);
      clicknotice.forEach(e => {
        reportGet(e);
      });
      //
    } else if (this.macro === 2) {
      this.landpage = replaceMacro2(this.videoRaw["landingpage"], event, {
        responseTime: this._responseTime + "",
        readyTime: this._readyTime + "",
        clickTime: +new Date() + "",
        showTime: this._showTime,
      });
      const clicknotice = (this.videoRaw["clicknotice"] || []).map(e => {
        return replaceMacro2(e, event, {
          responseTime: this._responseTime + "",
          readyTime: this._readyTime + "",
          clickTime: +new Date() + "",
          showTime: this._showTime
        });
      });
      clicknotice.forEach(e => {
        reportGet(e);
      });
    }
    console.log(this.landpage);
    // 跳转链接;
    this.linkToThird(this.landpage);
  };

  // 播放上报
  initVideoPlayReport(videoRaw) {
    const v = videoRaw.rewardvideo || {};
    this.playReport = {
      playStart: v.playstart || [],
      playEnd: v.playend || [],
      process25: v.firstquartile || [],
      process50: v.midpoint || [],
      porcess75: v.thirdquartile || [],
      playclosemid: v.playclosemid || [],
    };
  }

  // 视频地址和展示地址
  initVideo(videoRaw) {
    // 整理video对象
    const v = videoRaw.rewardvideo || {};
    this.url = v.video || '';
    console.log('iconicon', v.endcardicon);
    if (!v.endcardicon) {
      this.appContent = null;
      return;
    }
    this.appContent = {
      appIcon: v.endcardicon || '',
      name: v.endcardtitle || '',
      slogen: v.endcarddesc || ''
    };
  }

  // 跳转三方链接
  linkToThird(url) {
    window.location.href = url;
  };

  show() {
    this.el.style.display = 'block';
  }

  hide() {
    this.el.style.display = 'none';
  }

  play() {
    if (this.url) {
      this.show();
      this.player.load(this.url);
      if (this.appContent) {
        const starNum = [4, 4.5, 5][Math.floor(Math.random() * 3)];
        const commentNum = Math.floor(Math.random() * 5000 + 5000);
        this.player.emit('$landPageChangeApp',
          Object["assign"]({ starNum, buttonText: '立即下载', commentNum },
            this.appContent), true);
        this.player.emit('$footerPageChangeApp',
          Object["assign"]({ starNum, buttonText: '立即下载', commentNum },
            this.appContent), true);
      } else {
        this.player.emit('$landPageChangeApp', {}, null);
        this.player.emit('$footerPageChangeApp', {}, null);
      }
      this.player.emit('$videoReset');
      this.player.play();
      return this.playPromise;
    } else {
      return Promise.reject(new Error('url 不存在'));
    }
  }
};

export default MyAdvideo;
