import { IModuleData } from "../interface/IModuleData";

/**
 * 面板管理
 */
export abstract class ABPanelManager {

    constructor() {
    }

    /**
     * 显示面板
     * @param {ModuleData} module 模块
     * @param {any} data 数据
     */
    public abstract show(module: IModuleData, data: any): void

    /**
     * 关闭面板
     * @param moduleName
     * @param dispose
     */
    public abstract hide(moduleName: string, dispose?: boolean): void

    /**
     * 关闭所有面板
     * @param {boolean} dispose
     */
    public abstract hideAll(dispose?: boolean): void

    /**
     * 调用面板方法
     * @param {ModuleName} moduleName
     * @param {string} funcName
     * @param args
     */
    public abstract callFunc(moduleName: string, funcName: string, ...args): void
}