import { Data } from "../tw/data/Data";
import { NetName } from "../tw/enum/NetName";
import { showToast } from "./ctrls/toastCtrl";

export default (data?: Data, netname?: NetName) => {
    if (!data) {
        return showToast('活动太火爆了\n请稍后再来');
    }
    if (data.code == '999999999')//系统级别错误  系统异常，\n请刷新后重试。
        showToast('网络异常\n请隔一段时间再尝试');
    else if (data.code == '2002007013')
        showToast('元宝不足哦，快去玩游戏赢元宝吧');
    else if (data.code == 'E100202007' || data.code == 'E100202008' || data.code == 'E100202009' || data.code == 'E100202010')
        showToast('体力不足啦~ \n点击左上角体力处“+”获取体力吧');
    else if (data.code == 'E1002070002' || data.code == 'E1002070001') {
        showToast('哎呀，萌狮开小差啦！ \n过会再来看看吧！')
    }
    else if (data.code == '600005')
        showToast('体力值已达上限，不可购买')
    else if (data.code == '444444')
        showToast('操作太频繁，请稍后再试');
    else//其他异常
        showToast('活动太火爆了\n请稍后再来');
}
// export default (data: Data) => {
//     if (data.code == 'E999999999')
//         showAlertPanel(AlertType.NO_TYPE);
//     else if (data.code == 'E100201001')
//         showAlertPanel(AlertType.NOT_LOGIN);
//     else if (data.code == 'E100202007' || data.code == 'E100202008' || data.code == 'E100202009' || data.code == 'E100202010')
//         showAlertPanel(AlertType.NO_TIMES);
//     else
//         showAlertPanel(AlertType.NO_TYPE)
// }