
import { getlogItem } from "../../../src/Main";
import { addRankFriendList } from "../../../src/mapScene/RankFriendList";

import { changeMapScene } from "../../../src/startScene/StartScene";
import wait from "../../new_tc/wait";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import Panel from "./Panel";
export default class NoPrizePanel extends Panel {
    _level;
    start(data) {
        super.start();
        // this._level = parseInt(data.level + '');
        // this['lvTxt'].text = `关卡${this._level}`
        const {score} = data;
        this["scoretxt"].text = score+"分";

        this.showlog();
        NetManager.ins.hc_home(() => { }, window['collectRuleId']);

        const hc_submitData = DataManager.ins.getData('hc_submit').data;
        this.setStar(hc_submitData.stars);

        this['goBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.hidePanel();
            if (this._level + 1 <= window['last_level'])
                changeMapScene({ level: this._level + 1 });
            else
                changeMapScene();
        }, this);
        
        addRankFriendList(84,917.46,this);    
    }

    showlog() {
        NetManager.ins.showLog(getlogItem(16));
    }

    onTouchTap_closeBtn() {
        super.onTouchTap_closeBtn();
        changeMapScene();
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    async setStar(nums: number) {
        this['pic1'].visible = this['pic2'].visible = this['pic3'].visible = false;
        // this['light'].visible = false;
        await wait(500);
        if (nums == 1) {
            this['pic1'].visible = true;
            await this.playAni1();
        }
        if (nums == 2) {
            this['pic1'].visible = true;
            await this.playAni1();
            this['pic2'].visible = true;
            await this.playAni2();
        }
        if (nums == 3) {
            this['pic1'].visible = true;
            await this.playAni1();
            this['pic2'].visible = true;
            await this.playAni2();
            this['pic3'].visible = true;
            await this.playAni3();
        }
        if (nums >= 1) {
            // this['light'].visible = false;
            // egret.Tween.get(this['light']).set({ scaleX: 0, scaleY: 0, alpha: 0, }).to({ scaleX: 1, scaleY: 1, alpha: 1 }, 300).call(() => {
            //     egret.Tween.get(this['light'], { loop: true }).to({ rotation: 360 }, 3000);
            // });
        }
    }

    async playAni1() {
        return new Promise(r => {
            egret.Tween.get(this['pic1']).set({ scaleX: 0, scaleY: 0 }).to({ scaleX: -1, scaleY: 1 }, 400, egret.Ease.getBackOut(1)).call(r)
        })
    }
    async playAni2() {
        return new Promise(r => {
            egret.Tween.get(this['pic2']).set({ scaleX: 0, scaleY: 0 }).to({ scaleX: 1, scaleY: 1 }, 400, egret.Ease.getBackOut(1)).call(r)
        })
    }
    async playAni3() {
        return new Promise(r => {
            egret.Tween.get(this['pic3']).set({ scaleX: 0, scaleY: 0 }).to({ scaleX: 1, scaleY: 1 }, 400, egret.Ease.getBackOut(1)).call(r)
        })
    }
    destroy() {
        super.destroy();
        // egret.Tween.removeTweens(this['light']);
    }
    get skinKey() { return 'NoPrize' }

}