import getResPath from "../../libs/new_tc/getResPath";
import Scene from "../../libs/new_wx/components/Scene";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import { ModuleTypes } from "../../libs/new_wx/types/sceneTypes";
import { loadSvga } from "../loadSvga";
import MapBottomPart from "../mapScene/MapBottomPart";
import MapRpeatPart from "../mapScene/MapRpeatPart";
import MapTopPart from "../mapScene/MapTopPart";
import setGlow from "../setGlow";
const list = [
    '小提示：凑齐5个萌狮连消，可以开启大招哦！',
    '小提示：连续爆炸，得分会成倍增加~',
    '小提示：发光的小动物可以消除一整片区域哦！',
    '小提示：带箭头的小动物可以连消一行或一列~',
    '小提示：冰块对小动物不利，消除他们势在必行！',
    '万千烦恼丝，一起全消掉！',
    '连萌梦境，即将开启~'
]
export default class StartScene extends Scene {
    private STOP_PERCENT = 99;
    private _current = 0;
    private _timer;
    level;
    async start(data?) {
        super.start();
        if (data)
            this.level = data.level;
        this['container1'].x = 20;
        this['container4'].mask = this['progressmask'];
        this['maskwrapper'].mask = this['progressmask2'];

        this['progressmask2'].scaleX = 0;
        this['percentTxt'].text = `0%`;
        const index = Math.floor(Math.random() * list.length);
        this['tips'].text = list[index];
        // setGlow(this['tips'], 0xffffff, 1);
        if (data && Array.isArray(data)) {
            this['container3'].addChild(data[0]);
            this['container2'].addChild(data[1]);
            this['container1'].addChild(data[2]);
        }
        else {
            await Promise.all([
                loadSvga(getResPath() + 'resource/assets/svgas/loading_progress.svga', this['container3']),
                loadSvga(getResPath() + 'resource/assets/svgas/loading_animals.svga', this['container2']),
                loadSvga(getResPath() + 'resource/assets/svgas/loading_title.svga', this['container1'])
            ]);
        }



        this._timer = setInterval(() => {
            this._current += 2;
            if (this._current >= this.STOP_PERCENT) {
                this._current = this.STOP_PERCENT;
            }
            this.setProgress(this._current);
        }, 100);

        //加载下一个场的资源
        if (!window['development']) {
            const key = 'map'; //先加载地图的所有资源，包括图集
            const promise = Promise.all([
                RES.getResAsync(`${key}_json`),
                RES.getResAsync(`${key}_png`),
                RES.getResAsync(`map1_jpg`),
                RES.getResAsync(`map2_jpg`),
                RES.getResAsync(`map3_jpg`),
            ]
            );
            promise.then(() => {
                this.createMap((d) => this.onProgressComplete(d));
            });
        } else {
            this.createMap((d) => this.onProgressComplete(d))
        }
    }

    async createMap(callback: Function) { //提前创建地图，以防止卡顿
        const data = createData();
        callback(data);
    }

    setProgress(per: number) {
        egret.Tween.removeTweens(this['progressmask2']);
        egret.Tween.get(this['progressmask2']).to({ scaleX: per / 100 }, 100);
        this['percentTxt'].text = `${per}%`
    }

    onProgressComplete(d) {
        setTimeout(() => {
            egret.Tween.removeTweens(this['progressmask2']);
            egret.Tween.get(this['progressmask2']).to({ scaleX: 1 }, 200).wait(200).call(() => {
                d.level = this.level;
                SceneCtrl.instance.change(ModuleTypes.MAP_SCENE, d);
            });
            this['percentTxt'].text = `100%`
            clearInterval(this._timer);
        }, 200 + 1700);
    }

    get skinKey() { return 'Start' }
}

export const changeMapScene = (p?) => {
    const data = createData();
    if (p) {
        data.level = p.level;
    } else {
        data.level = null;
    }
    SceneCtrl.instance.change(ModuleTypes.MAP_SCENE, data);
}

let _startSceneData;
export const createData = () => {
    if (_startSceneData) return _startSceneData;
    const startSceneData: any = {};
    _startSceneData = startSceneData;

    if (_startSceneData.level === null || _startSceneData.level === undefined) delete _startSceneData.level;

    const repeatCount = getRepeatCount();
    const list = [];
    startSceneData.list = list;

    startSceneData.top = new MapTopPart();
    startSceneData.top.loadSkin(); startSceneData.top.start();

    for (let i = 0; i < repeatCount; i++) {
        const repeat = new MapRpeatPart(i, startSceneData.top.height);
        repeat.loadSkin(); repeat.start();
        list.push(repeat);
    }

    startSceneData.bottom = new MapBottomPart();
    startSceneData.bottom.loadSkin();
    startSceneData.bottom.start({
        repeatHeight: list[0].height,
        topHeight: startSceneData.top.height
    });

    return startSceneData
}

export const getRepeatCount = () => {
    return (window['total_level'] - 18) / 13;
}