

import { State } from "../class/State";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { ElementType } from "../enum/ElementType";

/**
 * 褐色帽绣毛球状态
 * 分裂动画都在外面单独掉
 */
export class HairballGreyState extends State {
    private showImage: egret.Bitmap;
    constructor() {
        super();
        var texture: egret.Texture = RES.getRes("ele" + ElementType.HAIRBALLGREY + "_png")
        this.showImage = new egret.Bitmap(texture);
        this.addChild(this.showImage);
        this.showImage.x = -texture.textureWidth / 2;
        this.showImage.y = -texture.textureHeight / 2;
    }
    reset() {

    }
    recover() {
        if (this.parent) this.parent.removeChild(this);
        Pool.recover(RecoverName.HAIRBALLGREY_STATE, this);
    }
}