import { RecoverName } from "./RecoverName";
import { BubbleState } from "../states/BubbleState";
import { LockState } from "../states/LockState";
import { HairballGreyState } from "../states/HairballGreyState";
import { HairballBrownState } from "../states/HairballBrownState";
import { HairballBlackState } from "../states/HairballBlackState";

/**
 * 状态类型
 */
export enum StateType {
    BUBBLE = 0,//变色气泡
    LOCK,//锁
    HAIRBALLGREY,//灰色毛球  ，一次就消除
    HAIRBALLBROWN,//褐色毛球 ，只能特效消除
    HAIRBALLBLACK,//黑色毛球 ，两次消除，一次闭眼
}


//与上面的枚举顺序一致
export const stateDatas: { recoverName: RecoverName, className: any }[] = [
    { recoverName: RecoverName.BUBBLE_STATE, className: BubbleState },
    { recoverName: RecoverName.LOCK_STATE, className: LockState },
    { recoverName: RecoverName.HAIRBALLGREY_STATE, className: HairballGreyState },
    { recoverName: RecoverName.HAIRBALLBROWN_STATE, className: HairballBrownState },
    { recoverName: RecoverName.HAIRBALLBLACK_STATE, className: HairballBlackState },
]