import { ElementType } from "../enum/ElementType";

export class Ice extends egret.Bitmap {
    /**
     * 消除次数
     */
    private _countNum: number;
    get countNum() {
        return this._countNum
    }
    set countNum(value: number) {
        this._countNum = value;
        if (value == 2) {
            this.alpha = 1;
        } else {
            this.alpha = 0.6;
        }
    }

    constructor(n: number = 2) {
        super()
        var texture: egret.Texture = RES.getRes("ele" + ElementType.ICE + "_png");
        this.texture = texture;
        this.anchorOffsetX = texture.textureWidth / 2;
        this.anchorOffsetY = texture.textureHeight / 2;
        if (n == 2) {
            this.alpha = 1;
        } else {
            this.alpha = 0.6;
        }
        this._countNum = n;
    }


    reset(n: number = 2) {
        this.scaleX = this.scaleY = 1;
        if (n == 2) {
            this.alpha = 1;
        } else {
            this.alpha = 0.6;
        }
        this._countNum = n;
    }



}