import { ChapterData } from "../interface/ChapterData";
import { PassType } from "../enum/PassType";
import { ElementType } from "../enum/ElementType";

/**
 * 41到60关数据
 */
export const Chapters3: ChapterData[] = [
    //41 测试果冻
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 12000, 25000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 2, 2, 2, 2, 2, 1, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 2, 5, 2, 2, 0, 0,
                0, 0, 5, 1, 1, 1, 5, 0, 0,
                0, 2, 2, 2, 5, 2, 2, 2, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 10, 0, 0, 0, 0,
                0, 0, 0, 40, 20, 40, 0, 0, 0,
                0, 0, 20, 20, 30, 40, 20, 0, 0,
                0, 20, 40, 30, 20, 30, 30, 10, 0,
                0, 0, 10, 20, 10, 20, 30, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 40, 40, 20, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 13, type: 0 },
                { index: 21, type: 0 },
                { index: 23, type: 0 },
                { index: 29, type: 0 },
                { index: 33, type: 0 },
                { index: 37, type: 0 },
                { index: 43, type: 0 }
            ]
        }
    },
    //42
    {
        baseElementTypes: [0, 1, 2, 4, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 57 }] },
        starScores: [6000, 15000, 21000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 5, 5, 5, 2, 0, 0,
                0, 2, 5, 2, 2, 2, 5, 2, 0,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                0, 2, 5, 2, 2, 2, 5, 2, 0,
                0, 0, 2, 5, 5, 5, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0
            ],
            baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 20, 0, 0, 0, 0, 0, 0, 20, 30, 10, 0, 0, 0, 0, 0, 0, 20, 20, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [],
            generateLats: [
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 11, type: 0 },
                { index: 12, type: 0 },
                { index: 13, type: 0 },
                { index: 14, type: 0 },
                { index: 15, type: 0 },
                { index: 19, type: 0 },
                { index: 20, type: 0 },
                { index: 21, type: 0 },
                { index: 22, type: 0 },
                { index: 23, type: 0 },
                { index: 24, type: 0 },
                { index: 25, type: 0 },
                { index: 27, type: 0 },
                { index: 28, type: 0 },
                { index: 29, type: 0 },
                { index: 33, type: 0 },
                { index: 34, type: 0 },
                { index: 35, type: 0 }
            ]
        }
    },
    //43
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 22, passTarget: { type: 1, elements: [{ type: 9, count: 41 }] }, starScores: [5000, 15000, 22000], map: { lattices: [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0], connectedLats: [], elements: [0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 4, 1, 1, 0, 0, 0, 1, 1, 4, 5, 4, 1, 1, 0, 1, 1, 4, 5, 5, 5, 4, 1, 1, 0, 1, 1, 4, 5, 4, 1, 1, 0, 0, 0, 1, 1, 4, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 4, type: 0 }, { index: 12, type: 0 }, { index: 14, type: 0 }, { index: 20, type: 0 }, { index: 24, type: 0 }, { index: 28, type: 0 }, { index: 34, type: 0 }, { index: 36, type: 0 }, { index: 44, type: 0 }] }
    },
    //44
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 39 }] },
        starScores: [8000, 15000, 31000],
        map: {
            lattices: [
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                3, 3, 3, 0, 0, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 2, 3,
                1, 1, 1, 0, 0, 0, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                4, 4, 4, 0, 0, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 0, 0, 4, 4, 4
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 13, 0, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0,
                0, 0, 0, 0, 23, 0, 0, 0, 0,
                0, 0, 0, 0, 22, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 40, type: [13, 12, 11, 23, 22, 21] }
            ]
        }
    },
    //45
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 5, count: 39 }] },
        starScores: [6000, 14000, 24000],
        map: {
            lattices: [1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
            connectedLats: [],
            elements: [4, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2],
            baseElements: [
                40, 0, 0, 0, 0, 0, 0, 0, 40,
                0, 40, 0, 0, 0, 0, 0, 40, 0,
                0, 0, 40, 0, 0, 0, 40, 0, 0,
                0, 0, 0, 40, 0, 40, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                43, 0, 0, 0, 0, 0, 0, 0, 43,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                43, 0, 0, 0, 40, 0, 0, 0, 43,
                0, 0, 0, 0, 24, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 8, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 40, type: 0 },
                { index: 41, type: 0 },
                { index: 42, type: 0 },
                { index: 43, type: 0 },
                { index: 44, type: 0 },
                { index: 48, type: 0 },
                { index: 49, type: 0 },
                { index: 50, type: 0 },
                { index: 57, type: 0 },
                { index: 58, type: 0, cus: [40, 44] },
                { index: 59, type: 0 }
            ]
        }
    },
    //46
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 32, passTarget: { type: 1, elements: [{ type: 9, count: 50 }] }, starScores: [6000, 14000, 25000], map: { lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1], connectedLats: [], elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 0, 1, 2, 1, 2, 2, 0, 0, 0, 1, 1, 2, 2, 2, 2, 1, 0, 0, 1, 1, 2, 2, 2, 2, 1, 0, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 4, 4, 4, 4, 4, 2, 1, 2, 2, 4, 4, 4, 4, 4, 2, 2, 2, 2, 4, 4, 4, 4, 4, 2, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 12, type: 0 }, { index: 13, type: 0 }, { index: 14, type: 0 }, { index: 20, type: 0 }, { index: 24, type: 0 }, { index: 28, type: 0 }, { index: 34, type: 0 }, { index: 45, type: 0 }, { index: 53, type: 0 }] }
    },
    //47
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 6, count: 23 }] },
        starScores: [6000, 12000, 18000],
        map: {
            lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            connectedLats: [[63, 14], [64, 15], [65, 16], [66, 17]],
            elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 3, 5, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            baseElements: [
                0, 0, 0, 0, 0, 10, 40, 40, 30,
                0, 0, 0, 0, 0, 20, 20, 40, 40,
                0, 0, 0, 0, 0, 10, 10, 30, 30,
                0, 0, 0, 0, 0, 20, 20, 40, 40,
                0, 0, 0, 0, 0, 30, 30, 10, 10,
                0, 0, 0, 0, 0, 40, 40, 20, 20,
                0, 0, 0, 0, 0, 20, 30, 40, 30,
                0, 0, 0, 0, 0, 11, 12, 21, 22,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [68, 69, 70, 71],
            generateLats: [
                { index: 9, type: 0 },
                { index: 10, type: 0 },
                { index: 11, type: 0 },
                { index: 12, type: 0 },

                { index: 27, type: 0 },
                { index: 28, type: 0 },
                { index: 29, type: 0 },
                { index: 30, type: 0 },

                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                
                { index: 45, type: 0 },
                { index: 46, type: 0 },
                { index: 47, type: 0 },
                { index: 48, type: 0 },
                
                { index: 54, type: 0 },
                { index: 55, type: 0 },
                { index: 56, type: 0 },
                { index: 57, type: 0 },
                
                { index: 63, type: 0 },
                { index: 64, type: 0 },
                { index: 65, type: 0 },
                { index: 66, type: 0 },

            ]
        }
    },
    //48
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 33,
        passTarget: { type: 1, elements: [{ type: 5, count: 34 }, { type: 9, count: 7 }] }, starScores: [5000, 12000, 24000], map: {
            lattices: [1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 2, 2, 1, 1, 0, 0, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 2], connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 2, 2, 2, 2, 2, 0, 0, 1, 1, 2, 5, 5, 2, 2, 0, 0, 1, 1, 2, 5, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 5, 5, 2, 2, 1, 1, 2, 2, 2, 5, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 5], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: 0 }, { index: 1, type: 0 }, { index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 43, type: 0 }, { index: 44, type: 0 }]
        }
    },
    //49
    {
        baseElementTypes: [1, 2, 0, 4], bubbleProbability: 0, stepCount: 28, passTarget: { type: 1, elements: [{ type: 5, count: 16 }] }, starScores: [6000, 12000, 20000],
        map: {
            lattices:
                [
                    0, 0, 0, 0, 0, 1, 1, 1, 1,
                    0, 0, 0, 0, 0, 1, 1, 1, 1,
                    0, 0, 0, 0, 0, 1, 1, 1, 1,
                    0, 0, 0, 0, 0, 1, 1, 1, 1,
                    1, 1, 1, 1, 0, 1, 1, 1, 1,
                    0, 0, 0, 0, 0, 1, 1, 1, 1,
                    1, 1, 1, 1, 0, 1, 1, 1, 1,
                    1, 1, 1, 1, 0, 1, 1, 1, 1,
                    1, 1, 1, 1, 0, 1, 1, 1, 1
                ],
            connectedLats: [],
            elements: [
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                1, 1, 1, 1, 0, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 5, 5, 5, 5,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                12, 31, 12, 31, 0, 12, 30, 30, 12,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                30, 10, 30, 10, 0, 0, 0, 0, 0,
                10, 30, 10, 30, 0, 0, 0, 0, 0,
                30, 10, 30, 10, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 14, type: 0 },
                { index: 15, type: 0 },
                { index: 16, type: 0 },
                { index: 17, type: 0 },
                { index: 23, type: 0 },
                { index: 24, type: 0 },
                { index: 25, type: 0 },
                { index: 26, type: 0 },
                { index: 32, type: 0 },
                { index: 33, type: 0 },
                { index: 34, type: 0 },
                { index: 35, type: 0 },
                { index: 41, type: 0 },
                { index: 42, type: 0 },
                { index: 43, type: 0 },
                { index: 44, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 54, type: 0 },
                { index: 55, type: 0 },
                { index: 56, type: 0 },
                { index: 57, type: 0 }
            ]
        }
    },
    //50
    {
        baseElementTypes: [1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 28 }] },
        starScores: [5000, 14000, 23000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                2, 2, 0, 1, 1, 1, 0, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 0, 0, 0, 1, 2, 2,
                2, 2, 1, 0, 1, 0, 1, 2, 2
            ],
            connectedLats: [[11, 29], [15, 33]],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                4, 4, 0, 2, 2, 2, 0, 4, 4,
                2, 5, 4, 2, 2, 2, 4, 5, 2,
                5, 2, 4, 1, 1, 1, 4, 2, 5,
                2, 5, 4, 1, 1, 1, 4, 5, 2,
                5, 2, 4, 1, 1, 1, 4, 2, 5,
                2, 5, 4, 0, 0, 0, 4, 5, 2,
                4, 4, 1, 0, 1, 0, 1, 4, 4
            ],
            baseElements: [
                0, 30, 50, 30, 40, 30, 50, 30, 0,
                0, 0, 0, 0, 33, 0, 0, 0, 0,
                20, 30, 0, 0, 0, 0, 0, 30, 20,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                0, 0, 20, 30, 42, 30, 20, 0, 0,
                0, 0, 30, 40, 50, 40, 30, 0, 0,
                0, 0, 20, 30, 40, 30, 20, 0, 0,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                20, 30, 30, 0, 21, 0, 30, 30, 20
            ],
            recycles: [],
            generateLats: [
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 18, type: 0 },
                { index: 19, type: 0 },
                { index: 25, type: 0 },
                { index: 26, type: 0 },
                { index: 39, type: 0 },
                { index: 40, type: 0 },
                { index: 41, type: 0 }
            ]
        }
    },
    //51
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 38,
        passTarget: { type: 1, elements: [{ type: 9, count: 14 }] },
        starScores: [8000, 12000, 24000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                2, 1, 3, 3, 3, 3, 3, 1, 2,
                1, 1, 3, 3, 3, 3, 3, 1, 1,
                2, 1, 1, 1, 1, 1, 1, 1, 2
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                0, 2, 5, 5, 5, 5, 5, 2, 0,
                0, 5, 0, 0, 0, 0, 0, 5, 0,
                5, 5, 0, 0, 0, 0, 0, 5, 5,
                0, 5, 5, 5, 5, 5, 5, 5, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: 0 }, { index: 1, type: 0 }, { index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 7, type: 0 }, { index: 8, type: 0 }]
        }
    },
    //52
    { baseElementTypes: [0, 1, 2, 4, 3], bubbleProbability: 0, stepCount: 43, passTarget: { type: 1, elements: [{ type: 6, count: 4 }] }, starScores: [6000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 5, 1, 1, 1, 5, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: 0 }, { index: 1, type: 0 }, { index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 7, type: 0 }, { index: 8, type: 0 }] } },
    //53
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 30, passTarget: { type: 1, elements: [{ type: 9, count: 34 }] }, starScores: [6000, 14000, 24000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1], connectedLats: [], elements: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1, 1, 1, 2, 4, 2, 4, 2, 1, 1, 1, 2, 4, 2, 0, 2, 4, 2, 1, 2, 4, 2, 0, 0, 0, 2, 4, 2, 4, 2, 0, 0, 0, 0, 0, 2, 4, 2, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 10, type: 0 }, { index: 16, type: 0 }, { index: 18, type: 0 }, { index: 26, type: 0 }] }
    },
    //54
    {
        baseElementTypes: [1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 9, count: 28 }] },
        starScores: [5000, 12000, 20000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 0, 1, 0, 1, 0, 1, 0, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                1, 0, 3, 3, 3, 3, 3, 0, 1,
                1, 0, 3, 3, 3, 3, 3, 0, 1,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0
            ],
            connectedLats: [[14, 32], [12, 30], [57, 9], [59, 17]],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 11, type: 0 }, { index: 12, type: 0 }, { index: 13, type: 0 }, { index: 14, type: 0 }, { index: 15, type: 0 }]
        }
    },
    //55
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 28, passTarget: { type: 1, elements: [{ type: 9, count: 15 }] }, starScores: [6000, 14000, 25000], map: {
            lattices: [1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 2, 2, 2, 1, 1, 1, 0, 0, 0, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 2, 2, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1],
            connectedLats: [[18, 36], [19, 37], [11, 38], [63, 16], [64, 17], [56, 24], [42, 69], [43, 61], [44, 62]], elements: [1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 2, 2, 2, 1, 1, 1, 0, 0, 0, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 2, 2, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },

            ]
        }
    },
    //56
    { baseElementTypes: [0, 1, 3, 2, 4], bubbleProbability: 0, stepCount: 32, passTarget: { type: 1, elements: [{ type: 9, count: 39 }] }, starScores: [6000, 14000, 25000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 5, 5, 5, 2, 2, 1, 2, 4, 2, 5, 4, 5, 2, 4, 2, 1, 2, 2, 5, 5, 5, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] } },
    //57  有气泡
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0.8,
        stepCount: 27,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 15
                },
            ]
        },
        starScores: [4000, 8000, 18000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                1, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
            ],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                7, 0, 0, 0, 0, 0, 0, 0, 7,
                7, 7, 2, 2, 2, 2, 2, 7, 7,
                7, 7, 7, 7, 2, 7, 7, 7, 7,
                7, 7, 7, 7, 2, 7, 7, 7, 7,
                7, 7, 7, 7, 2, 7, 7, 7, 7,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
            ],
            connectedLats: [[20, 38], [21, 39], [22, 40], [23, 41], [24, 42]],
        },
    },
    //58
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 6, count: 4 }] },
        starScores: [5000, 8000, 15000],
        map: {
            lattices: [
                1, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 0, 0, 0, 0, 0, 1,
                1, 1, 1, 1, 0, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1
            ],
            connectedLats: [[79, 10], [80, 20], [78, 0]],
            elements: [
                3, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 0, 0, 0, 0, 0, 3,
                1, 1, 1, 1, 0, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 2, 0, 2, 1, 1,
                1, 1, 1, 1, 2, 0, 2, 1, 1,
                1, 1, 1, 1, 2, 0, 2, 2, 2,
                1, 2, 2, 2, 2, 0, 2, 2, 2
            ],
            baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [72, 73, 74, 75, 76],
            generateLats: [
                { index: 26, type: null },
                { index: 30, type: null },
                { index: 34, type: null },
                { index: 40, type: null },
                { index: 42, type: null }
            ]
        }
    },
    //59
    {
        baseElementTypes: [0, 1, 2, 4, 3],
        bubbleProbability: 0.1,
        stepCount: 31,
        passTarget: { type: 1, elements: [{ type: 9, count: 30 }] },
        starScores: [5000, 12000, 18000],
        map: {
            lattices: [
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 3, 1, 1, 3, 3, 3, 0,
                3, 1, 1, 1, 1, 1, 1, 3, 0,
                1, 3, 1, 3, 3, 1, 3, 1, 0,
                0, 1, 3, 1, 1, 3, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            connectedLats: [],
            elements: [
                2, 2, 1, 1, 1, 1, 2, 2, 0,
                2, 2, 1, 1, 1, 1, 2, 2, 0,
                2, 2, 1, 1, 1, 1, 2, 2, 0,
                2, 2, 2, 1, 1, 2, 2, 2, 0,
                2, 1, 1, 1, 1, 1, 1, 2, 0,
                2, 2, 1, 2, 2, 1, 2, 2, 0,
                1, 2, 2, 1, 1, 2, 2, 1, 0,
                0, 1, 2, 2, 2, 2, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 12, 13, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
            ]
        }
    },
    //60
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0.1,
        stepCount: 33,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 12000, 18000],
        map: {
            lattices: [
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                0, 3, 1, 1, 2, 1, 3, 0, 0,
                0, 3, 3, 1, 1, 3, 3, 0, 0,
                3, 1, 1, 1, 1, 1, 1, 3, 0,
                1, 3, 1, 3, 3, 1, 3, 1, 0,
                1, 1, 3, 1, 1, 3, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                1, 2, 2, 2, 2, 2, 2, 4, 0,
                2, 1, 2, 2, 2, 2, 4, 2, 0,
                2, 2, 1, 2, 2, 4, 2, 2, 0,
                0, 2, 2, 1, 4, 2, 2, 0, 0,
                0, 2, 2, 4, 1, 2, 2, 0, 0,
                4, 2, 7, 2, 2, 1, 2, 1, 0,
                2, 1, 2, 2, 2, 2, 1, 2, 0,
                4, 2, 4, 2, 2, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            baseElements: [
                20, 0, 0, 0, 0, 0, 0, 40, 0,
                0, 20, 0, 0, 0, 0, 40, 0, 0,
                0, 0, 14, 0, 0, 40, 0, 0, 0,
                0, 0, 0, 20, 40, 0, 0, 0, 0,
                0, 0, 0, 40, 22, 0, 0, 0, 0,
                40, 0, 40, 0, 0, 20, 0, 20, 0,
                0, 40, 0, 12, 13, 0, 20, 0, 0,
                40, 0, 40, 0, 0, 20, 14, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },

            ]
        }
    },
]