import { Ani } from "../class/Ani";
import { ImageAni } from "../class/ImageAni";
import { ElementType } from "../enum/ElementType";

//原点已是中心
export class IceAni extends Ani {
    /**
     * 图片
     */
    showImage: ImageAni;
    constructor() {
        super();
        this.aniName = "IceAni";
        this.showImage = new ImageAni(["ele" + ElementType.ICE + "_png", "ice2_png", "ice3_png", "ice4_png", "ice5_png", "ice6_png"]);
        this.addChild(this.showImage)
    }

    play() {
        //重置图片
        this.showImage.currentFrame = 0;
        this.showImage.source = this.showImage.sourceAll[0];
        this.showImage.play(() => {
            this.recover();
        })
    }
} 