import { Tool } from "../Tool";
import { ElementType } from "../enum/ElementType";
import { EffectType } from "../enum/EffectType";
import { Element } from "../class/Element";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";

/**
 * 元素向下的动画
 * 没有遮罩
 * @param eleC 
 * @param p 
 * @param con 
 * @param callback 
 */
export function EleDownAni(
    eleC: Element,
    p: number[],
    wait: number,
    con: egret.DisplayObjectContainer,
    isUp: boolean = false,
    deltaTime:number,
    callback?: Function
) {
    let ele = Tool.getElement(eleC.type);
    ele.effectType = eleC.effectType;
    ele.x = p[0];
    ele.y = p[1] - Tool.height * (isUp ? 0 : 1);
    egret.Tween.get(ele)
        .wait(wait)
        .call(()=>{
            con.addChild(ele);
        })
        .to({ x: p[0], y: p[1] + Tool.height * (isUp ? 1 : 0) }, deltaTime)
        .call(() => {
            //回收元素
            con.removeChild(ele);
            Pool.recover(RecoverName.ELEMENT, ele);
            //回调
            callback && callback();
        })
}