import { ImageAni } from "../class/ImageAni";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { playSound, SoundType } from "../../soundCtrl";


export const stepPosition: number[] = [125, 115];
/**
 * 需要回调的
 * 手动修改this.shoot.rotation=
 */
export class BonusShootAni extends egret.DisplayObjectContainer {
    shoot: egret.Bitmap;
    imageAni: ImageAni
    constructor() {
        super()
        var texture = RES.getRes("bonusShoot_png")
        this.shoot = new egret.Bitmap(texture);
        this.shoot.anchorOffsetX = 78;
        this.shoot.anchorOffsetY = 37 / 2;
        this.addChild(this.shoot);
        var arr = []
        for (var i = 1; i <= 27; i++) {
            arr.push("bonusFra" + i + "_png");
        }
        this.imageAni = new ImageAni(arr);
        this.addChild(this.imageAni);
        this.imageAni.visible = false
    }
    reset() {
        this.shoot.visible = true;
        this.imageAni.visible = false;
        this.x = stepPosition[0];
        this.y = stepPosition[1];
    }

    play(rotation: number, p: number[], callback: Function) {
        this.reset()
        this.shoot.rotation = rotation;
        egret.Tween.get(this)
            .to({ x: p[0], y: p[1] }, 300)
            .call(() => {
                callback();
                playSound(SoundType.bonusShoot)
                this.shoot.visible = false;
                this.imageAni.visible = true;
                this.imageAni.play(() => {
                    if (this.$parent) {
                        this.$parent.removeChild(this)
                    };
                    Pool.recover(RecoverName.BONUSSHOOT_ANI, this)
                    // callback();
                })
            })
    }
}