
import getHomeData from "../getHomeData";
import { changeMapScene } from "../startScene/StartScene";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import MapScene from "../mapScene/MapScene";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";

export const gotoNextLevel = (currentLevel?) => {
    if (!currentLevel) {
        currentLevel = getHomeData().levels.length;
    }
    const onMapScene = SceneCtrl.instance.currentScene instanceof MapScene;
    const configData = DataManager.ins.getData('getConfig')
    const configDetData = configData.data.list ? configData.data.list : configData.data
    let startConfigData = configDetData.filter(item => item.id === 2)
    let startPanelType = 'StartPanel'
    if (startConfigData.length && startConfigData[0].index === 0) startPanelType = 'StartPanelNew'

    if (currentLevel + 1 <= window['last_level']) {
        if (onMapScene)
            PanelCtrl.instance.show(startPanelType, currentLevel + 1)
        else
            changeMapScene({ level: currentLevel + 1 });
    }
    else {
        if (!onMapScene)
            changeMapScene();
    }
}