import Panel from "../../libs/new_wx/components/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PropType from "../PropType";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import { getlogItem } from "../Main";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import setGlow from "../setGlow";
import getHomeData from "../getHomeData";
import { showToast2 } from "../../libs/new_wx/ctrls/toastCtrl2";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import MainScene from "../mainScene/MainScene";
import Loading from "../../libs/new_wx/components/Loading";
import { handleVideo } from "../myVideo/videoCtrl";
import handleInspireVideo from "../inspireVideo";

export default class VideoBuyPanel extends Panel {
    buyBtn: eui.Button
    hasYuanbao: eui.Group
    start(data: { propType: PropType, showVideo: boolean, complete: Function }) {
        super.start();
        //显示图片
        this["prop" + data.propType].visible = true;
        //购买
        this['buyBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            Loading.instace.show();
            NetManager.ins.hc_exchange((success) => {
                Loading.instace.hide();
                if (success) {
                    this.hidePanel();
                    showToast('兑换成功');
                    //消耗掉
                    NetManager.ins.hc_useProp(() => { }, data.propType)
                    //回调
                    data.complete(false)
                } else {
                    showToast('元宝不足哦~\n快去玩游戏赢元宝吧');
                }
            }, data.propType);//兑换道具
        }, this);

        switch (data.propType) {
            case PropType.BOOM:
                this['priceTxt'].text = '-' + window['price2'];
                break;
            case PropType.HAMMER:
                this['priceTxt'].text = '-' + window['price3'];
                break;
            case PropType.CHANCE_NUM:
                this['priceTxt'].text = '-' + window['price4'];
                break;
        }
        this['moneyTxt'].text = getHomeData().wealth;

        setGlow(this['priceTxt'], 0x0083e8, 1);

        //曝光
        NetManager.ins.showLog(getlogItem(9))

        //看视频
        if (data.showVideo) {
            this["videoBtn"].visible = true;
            this["videoBtn"].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                NetManager.ins.clickLog(getlogItem(10))
                handleInspireVideo(
                    (s) => {
                        if (s) {
                            this.hidePanel();
                            //回调
                            data.complete(true);
                            showToast("领取成功")
                        } else {
                            showToast("广告未成功观看，道具领取失败")
                        }
                    },
                    () => { },
                    window["slotid"],
                )
            }, this);
        } else {
            this["videoBtn"].visible = false;
            this["hasYuanbao"].horizontalCenter = 0;
            this.buyBtn.horizontalCenter = 0;
            this["priceTxt"].x = 250;
        }
    }


    get skinKey() { return 'VideoBuy' }
}