import Panel from "../../libs/new_wx/components/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { addAdComp } from "./BoxPanel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { getlogItem } from "../Main";
import { handleVideo } from "../myVideo/videoCtrl";
import handleInspireVideo from "../inspireVideo";
import Loading from "../../libs/new_wx/components/Loading";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import { updateMainTimer } from "../../libs/new_wx/MainBase";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";

export default class SignPrizePanel extends Panel {
    doubleBtn: eui.Button
    start(data) {
        super.start();

        this['money'].visible = false;
        this['blood'].visible = false;
        this['numsgroup'].visible = true;

        //奖品类型，none无奖励, object实物，virtual虚拟商品，coupon券，道具prop，元宝coin，体力times，
        const { customInfo } = DataManager.ins.getData('dosign');
        const prizeType = customInfo.prizeType;
        if (customInfo.logo && prizeType != 'times' && prizeType != 'coin' && prizeType != 'prop') {
            this['img'].source = customInfo.logo;
            this['numsgroup'].visible = false;
        } else {
            if (customInfo.itemId)
                this['img'].source = `http://yun.duiba.com.cn/db_games/${window['imgver']}/${customInfo.itemId}.png`;
        }

        this['nums'].text = 'x' + customInfo.prizeCount;
        if (prizeType == 'prop') {
            // this['numsgroup'].x=396.38;
            this['numsgroup'].y = 380.8;
        }

        this['img'].visible = prizeType != 'times' && prizeType != 'coin';
        this['money'].visible = prizeType == 'coin';
        // this['propnums2'].visible = prizeType=='coin';
        this['blood'].visible = prizeType == 'times';
        // if(prizeType=='coin') {
        //     this['numsgroup'].visible=false;
        // }
        addAdComp(84, 779.37, this, 24);

        //曝光
        NetManager.ins.showLog(getlogItem(7))

        const configData = DataManager.ins.getData('getConfig')
        const configDetData = configData.data.list ? configData.data.list : configData.data
        let signConfigData = configDetData.filter(item => item.id === 6)
        if (signConfigData.length && signConfigData[0].index === 1) {
            // 因为除了插屏了，不需要翻倍
            this['close2Btn'].visible = true;
            this['doubleBtn'].visible = false;
        } else {
            // 依旧是视频翻倍
            this['doubleBtn'].visible = true;
            this["doubleBtn"].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                NetManager.ins.clickLog(getlogItem(8))
                handleInspireVideo(
                    (s) => {
                        if (s) {
                            Loading.instace.show();
                            NetManager.ins.getIncentiveAward(
                                (s) => {
                                    Loading.instace.hide();
                                    this['close2Btn'].visible = true;
                                    this['doubleBtn'].visible = false;
                                    if (s) {
                                        showToast("翻倍成功");
                                        NetManager.ins.hc_home(() => {
                                            updateMainTimer();
                                            SceneCtrl.instance.updateScene();
                                        }, window['collectRuleId']);
                                    } else {
                                        showToast("加倍失败");
                                        this.hidePanel();
                                    }
                                },
                                21
                            )
                        } else {
                            showToast("广告未成功观看，无法加倍领取");
                        }
                    },
                    () => {
                        NetManager.ins.getIncentiveAward(
                            () => { },
                            21)
                    },
                    window["slotid"]
                )
            }, this)
        }
    }



    onTouchTap_closeBtn() {
        super.onTouchTap_closeBtn();
    }

    get skinKey() { return 'SignPrize' }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn'], this['close2Btn']] }
}