import getSkinPath from "../../libs/new_wx/utils/getSkinPath";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { getlogItem } from "../Main";


export default class SignItem extends eui.ItemRenderer {
    constructor() {
        super();
        this.skinName = getSkinPath('SignItem');
    }

    dataChanged(){
        this['object'].visible=false;
        this['money'].visible=false;
        this['hammer'].visible=false;
        this['boom'].visible=false;
        this['steps'].visible=false;
        this['blood'].visible=false;
        this['random'].visible=false;
        this['quan15'].visible=false;
        this['quan58'].visible=false;
        this['quan38'].visible=false;

        this['btn1'].visible=false;
        this['btn2'].visible=false;
        this['btn3'].visible=false;
        this['btn4'].visible=false;

        this['line1'].visible=this.data.index!=6;
        this['line2'].visible=!this['line1'].visible;
        this['light'].visible=this.data.signed;
        this['title'].text = `连续签到${this.data.index+1}天`;

        this['amount'].text = this.data.config.nums;
        if(this.data.config.nums<=0)
        this['amount'].text = '';
        this[this.data.config.type].visible=true;

        this['btn'+this.data.btn].visible=true;
        if(this.data.btn ==1) {
            NetManager.ins.clickLog(getlogItem(22));
        }
       
        this['btn1'].addEventListener(egret.TouchEvent.TOUCH_TAP,()=>{
            this.data.func(this.data.index,this)
        },this);
    }

    setSinged(){
        this['btn1'].visible=false;
        this['btn2'].visible=false;
        this['btn3'].visible=false;
        this['btn4'].visible=false;

        this['light'].visible=true;
        this['btn2'].visible=true;
    }
}