import getSkinPath from "../../libs/new_wx/utils/getSkinPath";
import { getNick } from "../mapScene/MapScene";

export default class FriendItem2Renderer extends eui.ItemRenderer {
    constructor() {
        super();
        this.skinName = getSkinPath('FriendItem2');
    }
    
    score: eui.Label;
    dataChanged() {
        const {rank,nickName,avatar,maxScore}= this.data;

        this['avatar'].mask = this['avatarMask'];

        this['rankbg'].visible =this['rank1'].visible = this['rank2'].visible = this['rank3'].visible = this['rankTxt'].visible = false;
        this['rankTxt'].text = rank + '';
        if (rank == 1) {
            this['rank1'].visible = true;
        } else if (rank == 2) {
            this['rank2'].visible = true;
        } else if (rank == 3) {
            this['rank3'].visible = true;
        } else {
            this['rankTxt'].visible = true;
            this['rankbg'].visible = true;
        }

        this['avatar'].source = avatar||"http://yun.duiba.com.cn/db_games/default_avatar.png"

        this['nameTxt'].text = getNick(nickName);
        
        this.score.textFlow = (new egret.HtmlTextParser).parser(
            `<font color=0xff4501><b>${maxScore}</b></font>分`);
    }
}