import Panel from "../../libs/new_wx/components/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { addRankFriendList } from "../mapScene/RankFriendList";
import { changeMapScene } from "../startScene/StartScene";
import { handleVideo } from "../myVideo/videoCtrl";
import handleInspireVideo from "../inspireVideo";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import { getlogItem } from "../Main";
import { DataManager } from "../../libs/tw/manager/DataManager";

export default class FailedPanel extends Panel {
    _level;
    start(data) {
        super.start();
        if (data)
            this._level = parseInt(data.level + '');
        NetManager.ins.hc_home(() => { }, window['collectRuleId']);

        this['againBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.hidePanel();
            if (this._level)
                changeMapScene({ level: this._level });
            else
                changeMapScene();

        }, this);

        addRankFriendList(84, 772.52, this);

        //曝光
        NetManager.ins.showLog(getlogItem(3))

        //新增视频
        if (data.showVideo) {
            this["videoBtn"].visible = true;
            this["videoBtn"].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                NetManager.ins.clickLog(getlogItem(4))
                handleInspireVideo(
                    (s) => {
                        if (s) {
                            this.hidePanel();
                            data.complete();
                        } else {
                            showToast("广告未成功观看，请继续观看");
                        }
                    },
                    () => { },
                    window["slotid"]
                )
            }, this);
        }

        const configData = DataManager.ins.getData('getConfig')
        const configDetData = configData.data.list ? configData.data.list : configData.data
        const fileConfigData = configDetData.filter(item => item.id === 3)
        if (fileConfigData.length && fileConfigData[0].index === 0) {
            // 增加重新闯关倒计时
            let time = 5
            let againTimer = setInterval(() => {
                time--
                if (time > 0) {
                    this[`againBtn${time + 1}`].visible = false
                    this[`againBtn${time}`].visible = true
                } else {
                    this['againBtn1'].visible = false
                    this['againBtn'].visible = true
                    clearInterval(againTimer)
                    time = 5
                }
            }, 1000)
        } else {
            // 对照组，不加倒计时
            this['againBtn'].visible = true
            this['againBtn5'].visible = false
        }
    }

    onTouchTap_closeBtn() {
        super.onTouchTap_closeBtn();
        changeMapScene();
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    get skinKey() { return 'Fail' }
}