import Panel from "../../libs/new_wx/components/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { getlogItem } from "../Main";
import wait from "../../libs/new_tc/wait";

export default class ADPanel extends Panel {
    start(data) {
        super.start();
        this.showlog();

        let result;
        const hc_advert = DataManager.ins.getData('hc_advert').data;
        const { noticeAdvert } = hc_advert;
        this.visible = noticeAdvert.enable;

        this['adBtn'].mask = this['mask'];

        result = noticeAdvert.advertList;
        if (Array.isArray(noticeAdvert.advertList)) {
            const index = Math.floor(noticeAdvert.advertList.length * Math.random());
            result = noticeAdvert.advertList[index];
        }
        this.data.img = result.img;

        this['adBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            NetManager.ins.clickLog(getlogItem(25));
            wait(100).then(()=>{
                window.location.href = result.url;
            });
        }, this);
    }

    showlog() {
        NetManager.ins.showLog(getlogItem(25));
        // NetManager.ins.showLog(getlogItem(4));
    }

    initEvents() {
        super.initEvents();
        // this['inviteBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTapInvite, this)
    }

    onTouchTap_closeBtn(){
        super.onTouchTap_closeBtn();
        // 
    }

    onTapInvite() {

    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    get skinKey() { return 'AD' }
}