
class VideoControl {
  wrapperEl: any;
  el: HTMLDivElement;
  $player: any;
  $video: any;
  $wrapper: any;
  $contanier: any;
  constructor(config) {
    this.wrapperEl = config.el;
    this.el = document.createElement('div');
    this.wrapperEl.appendChild(this.el);
    this.$player = config.$player;
    this.$video = config.$video;
    this.$wrapper = config.$wrapper;
    this.$contanier = config.$contanier;
    this.el.addEventListener('click', () => {
      this.click();
    });
  }

  // 挂载
  mount() {
    this.wrapperEl.appendChild(this.el);
  }

  // 展示
  show() {
    this.el.style.opacity = 1+"";
  }

  // 隐藏
  hide() {
    this.el.style.opacity = 0+"";
  }

  // 点击
  click() {
    console.log('我被点击了');
  }
};

class MutedControl extends VideoControl {
  mutedEl: HTMLDivElement;
  voiceEl: HTMLDivElement;
  constructor(config) {
    super(config);
    this.mutedEl = document.createElement('div');
    this.mutedEl.classList.add('video-control-muted');
    this.voiceEl = document.createElement('div');
    this.voiceEl.classList.add('video-control-voice');
    this.el.appendChild(this.mutedEl);
    this.el.appendChild(this.voiceEl);
    this.el.classList.add('video-voice');
    super.mount();
  }

  show() {
    super.show();
    if (this.$video.muted) {
      this.showMuted();
    } else {
      this.showVoice();
    }
  }

  // 展示音量
  showVoice() {
    this.voiceEl.style.display = 'block';
    this.mutedEl.style.display = 'none';
  }

  // 展示静音
  showMuted() {
    this.mutedEl.style.display = 'block';
    this.voiceEl.style.display = '';
  }

  // 切换音量
  click() {
    if (this.$video.muted) {
      this.$video.muted = false;
      this.showVoice();
    } else {
      this.$video.muted = true;
      this.showMuted();
    }
  }
};

class CloseControl extends VideoControl {
  constructor(config) {
    super(config);
    this.el.classList.add('video-close');
    super.mount();
  }

  click() {
    console.log(this);
    this.$player.event.emit('$videoClose');
  }
};

class CountDownControl extends VideoControl {
  constructor(config) {
    super(config);
    this.el.classList.add('video-count-down');
    super.mount();
  }

  // 改变节奏
  changeText(text) {
    this.el.innerText = text;
  }
};

export default {
  name: 'video-control',
  zIndex: 3,
  poinerEvents: 'none',
  created() {
    this.el.classList.add('video-control');
    const config = {
      el: this.el,
      $video: this.$video,
      $wrapper: this.$wrapper,
      $contanier: this.$contanier,
      $player: this.$player
    };
    this.mutedControl = new MutedControl(config);
    this.closeControl = new CloseControl(config);
    this.countDownControl = new CountDownControl(config);
  },
  event: {
    canplay() {
      this.mutedControl.show();
      const duration = Math.floor(this.$video.duration);
      this.countDownControl.changeText(duration);
      this.countDownControl.show();
    },
    $closeShow() {
      this.closeControl.show();
    },
    ended() {
      this.closeControl.show();
    },
    timeupdate() {
      console.log(this.$video.currentTime);
      const time = Math.floor(this.$video.duration - this.$video.currentTime);
      if (isNaN(time)) {
        this.countDownControl.hide();
      } else {
        this.countDownControl.show();
      }
      this.countDownControl.changeText(time);
      this.$player.event.emit('$process', this.$video.currentTime / this.$video.duration * 100);
      if (time === 0) {
        this.countDownControl.hide();
      }
    },
    $videoReset() {
      this.closeControl.hide();
      this.countDownControl.hide();
      this.mutedControl.hide();
    }
  }
};
